/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import com.microsoft.bingads.v11.bulk.entities.BulkEntity;
import com.microsoft.bingads.v11.bulk.entities.BulkNegativeSite;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.internal.bulk.BulkObject;
import com.microsoft.bingads.v11.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v11.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.v11.internal.bulk.TryResult;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkEntityIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkNegativeSiteIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.MultiRecordBulkEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkNegativeSites<TNegativeSite extends BulkNegativeSite<TIdentifier>, TIdentifier extends BulkNegativeSiteIdentifier>
extends MultiRecordBulkEntity {
    private final List<TNegativeSite> bulkNegativeSites = new ArrayList<TNegativeSite>();
    private TIdentifier firstRowIdentifier;
    private boolean hasDeleteAllRow;
    private Status status;
    private Class<TNegativeSite> negativeSiteClass;
    private Class<TIdentifier> identifierClass;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<TNegativeSite> getNegativeSites() {
        return Collections.unmodifiableList(this.bulkNegativeSites);
    }

    @Override
    public List<? extends BulkEntity> getChildEntities() {
        return Collections.unmodifiableList(this.bulkNegativeSites);
    }

    protected BulkNegativeSites() {
    }

    protected BulkNegativeSites(TNegativeSite site, Class<TNegativeSite> negativeSiteClass, Class<TIdentifier> identifierClass) {
        this((TIdentifier)((BulkNegativeSite)site).getIdentifier(), negativeSiteClass, identifierClass);
        this.bulkNegativeSites.add(site);
    }

    protected BulkNegativeSites(TIdentifier identifier, Class<TNegativeSite> negativeSiteClass, Class<TIdentifier> identifierClass) {
        this.negativeSiteClass = negativeSiteClass;
        this.identifierClass = identifierClass;
        this.firstRowIdentifier = identifier;
        this.hasDeleteAllRow = ((BulkNegativeSiteIdentifier)identifier).isDeleteRow();
    }

    protected abstract TIdentifier createIdentifier();

    protected abstract void validatePropertiesNotNull();

    @Override
    public void writeToStream(BulkObjectWriter rowWriter, boolean excludeReadonlyData) throws IOException {
        this.validatePropertiesNotNull();
        TIdentifier deleteRow = this.createIdentifier();
        ((BulkNegativeSiteIdentifier)deleteRow).setStatus(Status.DELETED);
        rowWriter.writeObjectRow((BulkObject)deleteRow, excludeReadonlyData);
        if (this.status == Status.DELETED) {
            return;
        }
        for (BulkNegativeSite site : this.convertApiToBulkNegativeSites()) {
            site.writeToStream(rowWriter, excludeReadonlyData);
        }
    }

    protected abstract Iterable<TNegativeSite> convertApiToBulkNegativeSites();

    protected abstract void reconstructApiObjects();

    @Override
    public void readRelatedDataFromStream(BulkStreamReader reader) {
        boolean hasMoreRows = true;
        while (hasMoreRows) {
            TryResult<TNegativeSite> nextSiteResult = reader.tryRead(new Predicate<TNegativeSite>(){

                @Override
                public boolean test(TNegativeSite x) {
                    return ((BulkEntityIdentifier)((BulkNegativeSite)x).getIdentifier()).equals(BulkNegativeSites.this.firstRowIdentifier);
                }
            }, this.negativeSiteClass);
            if (nextSiteResult.isSuccessful()) {
                this.bulkNegativeSites.add(nextSiteResult.getResult());
                continue;
            }
            TryResult<TIdentifier> identifierResult = reader.tryRead(new Predicate<TIdentifier>(){

                @Override
                public boolean test(TIdentifier x) {
                    return ((BulkEntityIdentifier)x).equals(BulkNegativeSites.this.firstRowIdentifier);
                }
            }, this.identifierClass);
            if (identifierResult.isSuccessful()) {
                if (!((BulkNegativeSiteIdentifier)identifierResult.getResult()).isDeleteRow()) continue;
                this.hasDeleteAllRow = true;
                continue;
            }
            hasMoreRows = false;
        }
        this.reconstructApiObjects();
        this.status = this.bulkNegativeSites != null && this.bulkNegativeSites.size() > 0 ? Status.ACTIVE : Status.DELETED;
    }

    @Override
    public boolean allChildrenPresent() {
        return this.hasDeleteAllRow;
    }
}

