/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.ProductConditionHelper;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.campaignmanagement.ArrayOfProductCondition;
import com.microsoft.bingads.v11.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v11.campaignmanagement.ProductScope;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignProductScope
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private Status status;
    private static final List<BulkMapping<BulkCampaignProductScope>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion biddableCampaignCriterion = new BiddableCampaignCriterion();
        biddableCampaignCriterion.setCriterion(new ProductScope());
        biddableCampaignCriterion.setType(BiddableCampaignCriterion.class.getSimpleName());
        biddableCampaignCriterion.getCriterion().setType(ProductScope.class.getSimpleName());
        this.setBiddableCampaignCriterion(biddableCampaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, String>("Status", new Function<BulkCampaignProductScope, String>(){

            @Override
            public String apply(BulkCampaignProductScope c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, Long>("Id", new Function<BulkCampaignProductScope, Long>(){

            @Override
            public Long apply(BulkCampaignProductScope c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, Long>("Parent Id", new Function<BulkCampaignProductScope, Long>(){

            @Override
            public Long apply(BulkCampaignProductScope c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.getBiddableCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, String>("Campaign", new Function<BulkCampaignProductScope, String>(){

            @Override
            public String apply(BulkCampaignProductScope c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaignProductScope>(new BiConsumer<BulkCampaignProductScope, RowValues>(){

            @Override
            public void accept(BulkCampaignProductScope c, RowValues v) {
                ProductScope product = (ProductScope)c.getBiddableCampaignCriterion().getCriterion();
                if (product == null || product.getConditions() == null) {
                    return;
                }
                ProductConditionHelper.addRowValuesFromConditions(product.getConditions(), v);
            }
        }, new BiConsumer<RowValues, BulkCampaignProductScope>(){

            @Override
            public void accept(RowValues v, BulkCampaignProductScope c) {
                ProductScope product = (ProductScope)c.getBiddableCampaignCriterion().getCriterion();
                product.setConditions(new ArrayOfProductCondition());
                ProductConditionHelper.addConditionsFromRowValues(v, product.getConditions());
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

