/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.campaignmanagement.DeviceCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupDeviceCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupDeviceCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        DeviceCriterion deviceCriterion = new DeviceCriterion();
        adGroupCriterion.setCriterion(deviceCriterion);
        adGroupCriterion.getCriterion().setType(DeviceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupDeviceCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupDeviceCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Status", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, Long>("Id", new Function<BulkAdGroupDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupDeviceCriterion c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, Long>("Parent Id", new Function<BulkAdGroupDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupDeviceCriterion c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                c.getAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Campaign", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Ad Group", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Bid Adjustment", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("Target", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getAdGroupCriterion().getCriterion()).getDeviceName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getAdGroupCriterion().getCriterion()).setDeviceName(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDeviceCriterion, String>("OS Names", new Function<BulkAdGroupDeviceCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getAdGroupCriterion().getCriterion()).getOSName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDeviceCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDeviceCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getAdGroupCriterion().getCriterion()).setOSName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

