/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PerformanceData {
    private Double spend;
    private Integer impressions;
    private Integer clicks;
    private Double clickThroughRate;
    private Double averageCostPerClick;
    private Double averageCostPerThousandImpressions;
    private Double averagePosition;
    private Integer conversions;
    private Double costPerConversion;
    private static final List<BulkMapping<PerformanceData>> MAPPINGS;

    static PerformanceData readFromRowValuesOrNull(RowValues values) {
        PerformanceData performanceData = new PerformanceData();
        performanceData.readFromRowValues(values);
        return performanceData.hasAnyValues() ? performanceData : null;
    }

    static void writeToRowValuesIfNotNull(PerformanceData performanceData, RowValues values) {
        if (performanceData != null) {
            performanceData.writeToRowValues(values);
        }
    }

    public Double getSpend() {
        return this.spend;
    }

    public Integer getImpressions() {
        return this.impressions;
    }

    public Integer getClicks() {
        return this.clicks;
    }

    public Double getClickThroughRate() {
        return this.clickThroughRate;
    }

    public Double getAverageCostPerClick() {
        return this.averageCostPerClick;
    }

    public Double getAverageCostPerThousandImpressions() {
        return this.averageCostPerThousandImpressions;
    }

    public Double getAveragePosition() {
        return this.averagePosition;
    }

    public Integer getConversions() {
        return this.conversions;
    }

    public Double getCostPerConversion() {
        return this.costPerConversion;
    }

    void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    void writeToRowValues(RowValues values) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    private boolean hasAnyValues() {
        return this.spend != null || this.impressions != null || this.clicks != null || this.clickThroughRate != null || this.averageCostPerClick != null || this.averageCostPerThousandImpressions != null || this.averagePosition != null || this.conversions != null || this.costPerConversion != null;
    }

    private void setSpend(Double spend) {
        this.spend = spend;
    }

    private void setImpressions(Integer impressions) {
        this.impressions = impressions;
    }

    private void setClicks(Integer clicks) {
        this.clicks = clicks;
    }

    private void setClickThroughRate(Double clickThroughRate) {
        this.clickThroughRate = clickThroughRate;
    }

    private void setAverageCostPerClick(Double averageCostPerClick) {
        this.averageCostPerClick = averageCostPerClick;
    }

    private void setAverageCostPerThousandImpressions(Double averageCostPerThousandImpressions) {
        this.averageCostPerThousandImpressions = averageCostPerThousandImpressions;
    }

    private void setAveragePosition(Double averagePosition) {
        this.averagePosition = averagePosition;
    }

    private void setConversions(Integer conversions) {
        this.conversions = conversions;
    }

    private void setCostPerConversion(Double costPerConversion) {
        this.costPerConversion = costPerConversion;
    }

    static {
        ArrayList<SimpleBulkMapping<PerformanceData, Number>> m = new ArrayList<SimpleBulkMapping<PerformanceData, Number>>();
        m.add(new SimpleBulkMapping<PerformanceData, Double>("Spend", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getSpend();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setSpend(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Integer>("Impressions", new Function<PerformanceData, Integer>(){

            @Override
            public Integer apply(PerformanceData t) {
                return t.getImpressions();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setImpressions(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Integer>("Clicks", new Function<PerformanceData, Integer>(){

            @Override
            public Integer apply(PerformanceData t) {
                return t.getClicks();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setClicks(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Double>("CTR", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getClickThroughRate();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setClickThroughRate(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Double>("Avg CPC", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getAverageCostPerClick();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAverageCostPerClick(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Double>("Avg CPM", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getAverageCostPerThousandImpressions();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAverageCostPerThousandImpressions(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Double>("Avg position", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getAveragePosition();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAveragePosition(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Integer>("Conversions", new Function<PerformanceData, Integer>(){

            @Override
            public Integer apply(PerformanceData t) {
                return t.getConversions();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setConversions(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<PerformanceData, Double>("CPA", new Function<PerformanceData, Double>(){

            @Override
            public Double apply(PerformanceData t) {
                return t.getCostPerConversion();
            }
        }, new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setCostPerConversion(StringExtensions.nullOrDouble(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

