/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupRemarketingListAssociation;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupRemarketingListAssociationStatus;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupRemarketingListAssociation
extends SingleRecordBulkEntity {
    private AdGroupRemarketingListAssociation adGroupRemarketingListAssociation;
    private String campaignName;
    private String adGroupName;
    private String remarketingListName;
    private static final List<BulkMapping<BulkAdGroupRemarketingListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAdGroupRemarketingListAssociation(new AdGroupRemarketingListAssociation());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupRemarketingListAssociation(), "AdGroupRemarketingListAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AdGroupRemarketingListAssociation getAdGroupRemarketingListAssociation() {
        return this.adGroupRemarketingListAssociation;
    }

    public void setAdGroupRemarketingListAssociation(AdGroupRemarketingListAssociation adGroupRemarketingListAssociation) {
        this.adGroupRemarketingListAssociation = adGroupRemarketingListAssociation;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getRemarketingListName() {
        return this.remarketingListName;
    }

    public void setRemarketingListName(String remarketingListName) {
        this.remarketingListName = remarketingListName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Status", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return StringExtensions.toAdGroupRemarketingListAssociationStatusBulkString(c.getAdGroupRemarketingListAssociation().getStatus());
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getAdGroupRemarketingListAssociation().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupRemarketingListAssociationStatus>(){

                    @Override
                    public AdGroupRemarketingListAssociationStatus apply(String value) {
                        return AdGroupRemarketingListAssociationStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupRemarketingListAssociation().getId();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getAdGroupRemarketingListAssociation().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Parent Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupRemarketingListAssociation().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getAdGroupRemarketingListAssociation().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Campaign", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Ad Group", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Remarketing List", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getRemarketingListName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setRemarketingListName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Double>("Bid Adjustment", new Function<BulkAdGroupRemarketingListAssociation, Double>(){

            @Override
            public Double apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupRemarketingListAssociation().getBidAdjustment();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getAdGroupRemarketingListAssociation().setBidAdjustment(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Remarketing List Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupRemarketingListAssociation().getRemarketingListId();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getAdGroupRemarketingListAssociation().setRemarketingListId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

