/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.PerformanceData;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v10.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v10.campaignmanagement.FixedBid;
import com.microsoft.bingads.v10.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.ProductCondition;
import com.microsoft.bingads.v10.campaignmanagement.ProductPartition;
import com.microsoft.bingads.v10.campaignmanagement.ProductPartitionType;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupProductPartition
extends SingleRecordBulkEntity {
    private AdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupProductPartition>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.getPerformanceData(), values);
        }
    }

    public AdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(AdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupProductPartition, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupProductPartition, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Is Excluded", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return "False";
                }
                return "True";
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                boolean isExcluded;
                if ("yes".equals(v = v.toLowerCase()) || "true".equals(v)) {
                    isExcluded = true;
                } else if ("no".equals(v) || "false".equals(v)) {
                    isExcluded = false;
                } else {
                    throw new IllegalStateException(String.format("%s can only be set to TRUE or FALSE in %s ", "Is Excluded", BulkAdGroupProductPartition.class.getSimpleName()));
                }
                if (isExcluded) {
                    ProductPartition productPartition = new ProductPartition();
                    productPartition.setCondition(new ProductCondition());
                    productPartition.setType(ProductPartition.class.getSimpleName());
                    NegativeAdGroupCriterion negativeAdGroupCriterion = new NegativeAdGroupCriterion();
                    negativeAdGroupCriterion.setCriterion(productPartition);
                    negativeAdGroupCriterion.setType(NegativeAdGroupCriterion.class.getSimpleName());
                    c.setAdGroupCriterion(negativeAdGroupCriterion);
                } else {
                    ProductPartition productPartition = new ProductPartition();
                    productPartition.setCondition(new ProductCondition());
                    productPartition.setType(ProductPartition.class.getSimpleName());
                    FixedBid fixedBid = new FixedBid();
                    fixedBid.setType(FixedBid.class.getSimpleName());
                    BiddableAdGroupCriterion biddableAdGroupCriterion = new BiddableAdGroupCriterion();
                    biddableAdGroupCriterion.setCriterion(productPartition);
                    biddableAdGroupCriterion.setCriterionBid(fixedBid);
                    biddableAdGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
                    c.setAdGroupCriterion(biddableAdGroupCriterion);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Status", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, Long>("Id", new Function<BulkAdGroupProductPartition, Long>(){

            @Override
            public Long apply(BulkAdGroupProductPartition c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, Long>("Parent Id", new Function<BulkAdGroupProductPartition, Long>(){

            @Override
            public Long apply(BulkAdGroupProductPartition c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                c.getAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Campaign", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Ad Group", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Sub Type", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductPartitionType productPartitionType = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getPartitionType();
                    return productPartitionType == null ? null : productPartitionType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).setPartitionType(StringExtensions.parseOptional(v, new Function<String, ProductPartitionType>(){

                    @Override
                    public ProductPartitionType apply(String s) {
                        return ProductPartitionType.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, Long>("Parent Criterion Id", new Function<BulkAdGroupProductPartition, Long>(){

            @Override
            public Long apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    return ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getParentCriterionId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).setParentCriterionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Product Condition 1", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductCondition productCondition = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition();
                    return productCondition == null ? null : productCondition.getOperand();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition().setOperand(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Product Value 1", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductCondition productCondition = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition();
                    return productCondition == null ? null : productCondition.getAttribute();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition().setAttribute(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Bid", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toAdGroupBidBulkString(((FixedBid)bid).getBid());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((FixedBid)((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getCriterionBid()).setBid(StringExtensions.parseAdGroupBid(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Destination Url", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getDestinationUrl());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Final Url", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.writeUrls("; ", ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getFinalUrls());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ArrayOfstring urls = new ArrayOfstring();
                    List<String> urlArray = StringExtensions.parseUrls(v);
                    if (urlArray == null) {
                        urls = null;
                    } else {
                        urls.getStrings().addAll(urlArray);
                    }
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setFinalUrls(urls);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Mobile Final Url", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.writeUrls("; ", ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getFinalMobileUrls());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ArrayOfstring urls = new ArrayOfstring();
                    List<String> urlArray = StringExtensions.parseUrls(v);
                    if (urlArray == null) {
                        urls = null;
                    } else {
                        urls.getStrings().addAll(urlArray);
                    }
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setFinalMobileUrls(urls);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Tracking Template", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getTrackingUrlTemplate());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Custom Parameter", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toCustomParaBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getUrlCustomParameters());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    try {
                        ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

