/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.BulkSiteLinkAdExtension;
import com.microsoft.bingads.v10.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v10.campaignmanagement.SiteLink;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.v10.internal.bulk.entities.SiteLinkAdExtensionIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSiteLink
extends SingleRecordBulkEntity {
    private SiteLinkAdExtensionIdentifier identifier = new SiteLinkAdExtensionIdentifier();
    private int order;
    private SiteLink siteLink;
    private static final List<BulkMapping<BulkSiteLink>> MAPPINGS;

    SiteLinkAdExtensionIdentifier getIdentifier() {
        return this.identifier;
    }

    void setIdentifier(SiteLinkAdExtensionIdentifier identifier) {
        this.identifier = identifier;
    }

    public Long getAdExtensionId() {
        return this.identifier.getAdExtensionId();
    }

    public void setAdExtensionId(Long adExtensionId) {
        this.identifier.setAdExtensionId(adExtensionId);
    }

    public Long getAccountId() {
        return this.identifier.getAccountId();
    }

    public void setAccountId(Long accountId) {
        this.identifier.setAccountId(accountId);
    }

    public AdExtensionStatus getStatus() {
        return this.identifier.getStatus();
    }

    public void setStatus(AdExtensionStatus status) {
        this.identifier.setStatus(status);
    }

    public Integer getVersion() {
        return this.identifier.getVersion();
    }

    public void setVersion(Integer version) {
        this.identifier.setVersion(version);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public SiteLink getSiteLink() {
        return this.siteLink;
    }

    public void setSiteLink(SiteLink siteLink) {
        this.siteLink = siteLink;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.siteLink = new SiteLink();
        this.identifier.readFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.siteLink, "siteLink");
        this.identifier.writeToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public boolean canEncloseInMultilineEntity() {
        return true;
    }

    @Override
    public MultiRecordBulkEntity encloseInMultilineEntity() {
        return new BulkSiteLinkAdExtension(this);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSiteLink, Object>> m = new ArrayList<SimpleBulkMapping<BulkSiteLink, Object>>();
        m.add(new SimpleBulkMapping<BulkSiteLink, Integer>("Sitelink Extension Order", new Function<BulkSiteLink, Integer>(){

            @Override
            public Integer apply(BulkSiteLink c) {
                return c.getOrder();
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.setOrder(StringExtensions.parseInt(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Sitelink Extension Link Text", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return c.getSiteLink().getDisplayText();
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setDisplayText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Sitelink Extension Destination Url", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.toOptionalBulkString(c.getSiteLink().getDestinationUrl());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Sitelink Extension Description1", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return c.getSiteLink().getDescription1();
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setDescription1(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Sitelink Extension Description2", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return c.getSiteLink().getDescription2();
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setDescription2(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Device Preference", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.toDevicePreferenceBulkString(c.getSiteLink().getDevicePreference());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setDevicePreference(StringExtensions.parseDevicePreference(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Final Url", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.writeUrls("; ", c.getSiteLink().getFinalUrls());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getSiteLink().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Mobile Final Url", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.writeUrls("; ", c.getSiteLink().getFinalMobileUrls());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getSiteLink().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Tracking Template", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.toOptionalBulkString(c.getSiteLink().getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                c.getSiteLink().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSiteLink, String>("Custom Parameter", new Function<BulkSiteLink, String>(){

            @Override
            public String apply(BulkSiteLink c) {
                return StringExtensions.toCustomParaBulkString(c.getSiteLink().getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkSiteLink>(){

            @Override
            public void accept(String v, BulkSiteLink c) {
                try {
                    c.getSiteLink().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

