/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import com.microsoft.bingads.v10.bulk.entities.BulkRadiusTargetBid;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetWithLocation;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfRadiusTargetBid;
import com.microsoft.bingads.v10.campaignmanagement.IntentOption;
import com.microsoft.bingads.v10.campaignmanagement.LocationTarget;
import com.microsoft.bingads.v10.campaignmanagement.RadiusTarget;
import com.microsoft.bingads.v10.campaignmanagement.RadiusTargetBid;
import java.util.ArrayList;
import java.util.List;

abstract class BulkRadiusTarget<TBid extends BulkRadiusTargetBid>
extends BulkTargetWithLocation<TBid> {
    public BulkRadiusTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.reconstructApiBids(this.getBids(), new Function<TBid, RadiusTargetBid>(){

            @Override
            public RadiusTargetBid apply(TBid t) {
                return ((BulkRadiusTargetBid)t).getRadiusTargetBid();
            }
        }, new Supplier<RadiusTarget>(){

            @Override
            public RadiusTarget get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget();
            }
        }, new Supplier<RadiusTarget>(){

            @Override
            public RadiusTarget get() {
                return new RadiusTarget();
            }
        }, new Consumer<RadiusTarget>(){

            @Override
            public void accept(RadiusTarget t) {
                BulkRadiusTarget.this.getLocation().setRadiusTarget(t);
            }
        }, new Supplier<List<RadiusTargetBid>>(){

            @Override
            public List<RadiusTargetBid> get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget().getBids().getRadiusTargetBids();
            }
        }, new Consumer<List<RadiusTargetBid>>(){

            @Override
            public void accept(List<RadiusTargetBid> t) {
                BulkRadiusTarget.this.getLocation().getRadiusTarget().setBids(new ArrayOfRadiusTargetBid());
                BulkRadiusTarget.this.getLocation().getRadiusTarget().getBids().getRadiusTargetBids().addAll(t);
            }
        });
        if (!this.getBids().isEmpty()) {
            this.getLocation().setIntentOption(((BulkRadiusTargetBid)this.getBids().get(0)).getIntentOption());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList bulkBids = new ArrayList();
        this.convertBidsFromApi(bulkBids, new Supplier<RadiusTarget>(){

            @Override
            public RadiusTarget get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget();
            }
        }, new Function<RadiusTarget, List<RadiusTargetBid>>(){

            @Override
            public List<RadiusTargetBid> apply(RadiusTarget t) {
                return t.getBids().getRadiusTargetBids();
            }
        }, new BiConsumer<TBid, RadiusTargetBid>(){

            @Override
            public void accept(TBid t, RadiusTargetBid u) {
                ((BulkRadiusTargetBid)t).setRadiusTargetBid(u);
            }
        }, new Function<RadiusTargetBid, Boolean>(){

            @Override
            public Boolean apply(RadiusTargetBid t) {
                return true;
            }
        });
        for (BulkRadiusTargetBid bid : bulkBids) {
            bid.setIntentOption(this.getLocation().getIntentOption());
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getRadiusTarget(), "RadiusTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getRadiusTarget() != null) {
            this.validateListNotNullOrEmpty(this.getRadiusTarget().getBids(), this.getRadiusTarget().getBids().getRadiusTargetBids(), "RadiusTarget.Bids");
        }
    }

    public RadiusTarget getRadiusTarget() {
        return this.getLocationProperty(new Function<LocationTarget, RadiusTarget>(){

            @Override
            public RadiusTarget apply(LocationTarget t) {
                return t.getRadiusTarget();
            }
        });
    }

    public void setRadiusTarget(final RadiusTarget radiusTarget) {
        this.setLocationProperty(new Consumer<LocationTarget>(){

            @Override
            public void accept(LocationTarget t) {
                t.setRadiusTarget(radiusTarget);
            }
        });
    }

    public IntentOption getIntentOption() {
        return this.getLocationProperty(new Function<LocationTarget, IntentOption>(){

            @Override
            public IntentOption apply(LocationTarget t) {
                return t.getIntentOption();
            }
        });
    }

    public void setIntentOption(final IntentOption intentOption) {
        this.setLocationProperty(new Consumer<LocationTarget>(){

            @Override
            public void accept(LocationTarget t) {
                t.setIntentOption(intentOption);
            }
        });
    }
}

