/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.microsoft.bingads.v10.bulk.entities.BulkEntity;
import com.microsoft.bingads.v10.internal.bulk.BulkObject;
import com.microsoft.bingads.v10.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.v10.internal.bulk.EntityExtractor;
import com.microsoft.bingads.v10.internal.bulk.entities.MultiRecordBulkEntity;
import java.util.ArrayList;
import java.util.Iterator;

public class EntityIterator
implements Iterator<BulkEntity> {
    private BulkStreamReader reader;
    private Iterator<BulkEntity> nextBatch = null;
    private boolean isForFullDownload;

    public EntityIterator(BulkStreamReader reader, boolean isForFullDownload) {
        this.reader = reader;
        this.isForFullDownload = isForFullDownload;
    }

    @Override
    public boolean hasNext() {
        this.updateNextBatch();
        return this.nextBatch != null && this.nextBatch.hasNext();
    }

    @Override
    public BulkEntity next() {
        this.updateNextBatch();
        if (this.nextBatch != null && this.nextBatch.hasNext()) {
            BulkEntity returnEntity = this.nextBatch.next();
            return returnEntity;
        }
        throw new UnsupportedOperationException("Invalid bulk object returned!!!");
    }

    private void updateNextBatch() {
        if (this.nextBatch == null || !this.nextBatch.hasNext()) {
            this.nextBatch = this.readNextBatch();
        }
    }

    private Iterator<BulkEntity> readNextBatch() {
        BulkObject nextObject = this.reader.read();
        if (nextObject == null) {
            return null;
        }
        if (nextObject.canEncloseInMultilineEntity()) {
            MultiRecordBulkEntity multirecordEntity = nextObject.encloseInMultilineEntity();
            multirecordEntity.readRelatedDataFromStream(this.reader);
            if (this.isForFullDownload) {
                ArrayList<MultiRecordBulkEntity> entities = new ArrayList<MultiRecordBulkEntity>();
                entities.add(multirecordEntity);
                return entities.iterator();
            }
            return EntityExtractor.extractChildEntitiesIfNeeded(multirecordEntity);
        }
        if (BulkEntity.class.isInstance(nextObject)) {
            ArrayList entities = new ArrayList();
            entities.add(BulkEntity.class.cast(nextObject));
            return entities.iterator();
        }
        throw new UnsupportedOperationException("Invalid bulk object returned!!!");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

