/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.CouldNotUploadFileException;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.utilities.HttpClientHttpFileService;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.SimpleZipExtractor;
import com.microsoft.bingads.internal.utilities.ZipExtractor;
import com.microsoft.bingads.v10.bulk.ArrayOfCampaignScope;
import com.microsoft.bingads.v10.bulk.ArrayOflong;
import com.microsoft.bingads.v10.bulk.BulkDownloadOperation;
import com.microsoft.bingads.v10.bulk.BulkEntityIterable;
import com.microsoft.bingads.v10.bulk.BulkFileReader;
import com.microsoft.bingads.v10.bulk.BulkFileWriter;
import com.microsoft.bingads.v10.bulk.BulkOperation;
import com.microsoft.bingads.v10.bulk.BulkOperationProgressInfo;
import com.microsoft.bingads.v10.bulk.BulkOperationStatus;
import com.microsoft.bingads.v10.bulk.BulkUploadOperation;
import com.microsoft.bingads.v10.bulk.CampaignScope;
import com.microsoft.bingads.v10.bulk.CouldNotSubmitBulkDownloadException;
import com.microsoft.bingads.v10.bulk.CouldNotSubmitBulkUploadException;
import com.microsoft.bingads.v10.bulk.DownloadCampaignsByAccountIdsRequest;
import com.microsoft.bingads.v10.bulk.DownloadCampaignsByAccountIdsResponse;
import com.microsoft.bingads.v10.bulk.DownloadCampaignsByCampaignIdsRequest;
import com.microsoft.bingads.v10.bulk.DownloadCampaignsByCampaignIdsResponse;
import com.microsoft.bingads.v10.bulk.DownloadFileType;
import com.microsoft.bingads.v10.bulk.DownloadParameters;
import com.microsoft.bingads.v10.bulk.DownloadStatus;
import com.microsoft.bingads.v10.bulk.EntityUploadParameters;
import com.microsoft.bingads.v10.bulk.FileUploadParameters;
import com.microsoft.bingads.v10.bulk.GetBulkUploadUrlRequest;
import com.microsoft.bingads.v10.bulk.GetBulkUploadUrlResponse;
import com.microsoft.bingads.v10.bulk.IBulkService;
import com.microsoft.bingads.v10.bulk.Progress;
import com.microsoft.bingads.v10.bulk.ResultFileType;
import com.microsoft.bingads.v10.bulk.SubmitDownloadParameters;
import com.microsoft.bingads.v10.bulk.SubmitUploadParameters;
import com.microsoft.bingads.v10.bulk.UploadStatus;
import com.microsoft.bingads.v10.bulk.entities.BulkEntity;
import com.microsoft.bingads.v10.internal.bulk.BulkFileReaderFactory;
import com.microsoft.bingads.v10.internal.bulk.CSVBulkFileReaderFactory;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.http.HttpRequest;

public class BulkServiceManager {
    private static final String FORMAT_VERSION = "4.0";
    private AuthorizationData authorizationData;
    private HttpFileService httpFileService;
    private ZipExtractor zipExtractor;
    private BulkFileReaderFactory bulkFileReaderFactory;
    private ApiEnvironment apiEnvironment;
    private int statusPollIntervalInMilliseconds;
    private final ServiceClient<IBulkService> serviceClient;
    private File workingDirectory;

    public BulkServiceManager(AuthorizationData authorizationData) {
        this(authorizationData, null);
    }

    public BulkServiceManager(AuthorizationData authorizationData, ApiEnvironment apiEnvironment) {
        this(authorizationData, new HttpClientHttpFileService(), new SimpleZipExtractor(), new CSVBulkFileReaderFactory(), apiEnvironment);
    }

    private BulkServiceManager(AuthorizationData authorizationData, HttpFileService httpFileService, ZipExtractor zipExtractor, BulkFileReaderFactory bulkFileReaderFactory, ApiEnvironment apiEnvironment) {
        this.authorizationData = authorizationData;
        this.httpFileService = httpFileService;
        this.zipExtractor = zipExtractor;
        this.bulkFileReaderFactory = bulkFileReaderFactory;
        this.apiEnvironment = apiEnvironment;
        this.serviceClient = new ServiceClient<IBulkService>(this.authorizationData, apiEnvironment, IBulkService.class);
        this.workingDirectory = new File(System.getProperty("java.io.tmpdir"), "BingAdsSDK");
        this.statusPollIntervalInMilliseconds = 5000;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public Future<BulkEntityIterable> downloadEntitiesAsync(DownloadParameters parameters, AsyncCallback<BulkEntityIterable> callback) {
        return this.downloadEntitiesAsync(parameters, null, callback);
    }

    public Future<BulkEntityIterable> downloadEntitiesAsync(DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        this.validateSubmitDownloadParameters(parameters.getSubmitDownloadParameters());
        this.validateUserData();
        return this.downloadEntitiesAsyncImpl(parameters, progress, callback);
    }

    public Future<BulkEntityIterable> uploadEntitiesAsync(EntityUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        this.validateEntityUploadParameters(parameters);
        this.validateUserData();
        return this.uploadEntitiesAsyncImpl(this.createFileUploadParameters(parameters), progress, callback);
    }

    public Future<BulkEntityIterable> uploadEntitiesAsync(EntityUploadParameters parameters, AsyncCallback<BulkEntityIterable> callback) {
        return this.uploadEntitiesAsync(parameters, null, callback);
    }

    public Future<File> uploadFileAsync(FileUploadParameters parameters, AsyncCallback<File> callback) {
        return this.uploadFileAsync(parameters, null, callback);
    }

    public Future<File> uploadFileAsync(FileUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        this.validateSubmitUploadParameters(parameters.getSubmitUploadParameters());
        this.validateUserData();
        return this.uploadFileAsyncImpl(parameters, progress, callback);
    }

    private void validateEntityUploadParameters(EntityUploadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        if (parameters.getEntities() == null) {
            throw new NullPointerException("parameters.getEntities() must not be null");
        }
        if (!parameters.getEntities().iterator().hasNext()) {
            throw new IllegalArgumentException("parameters.getEntities() must not be empty");
        }
    }

    private void validateSubmitUploadParameters(SubmitUploadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        if (parameters.getUploadFilePath() == null) {
            throw new NullPointerException("parameters.getUploadFilePath() must not be null");
        }
    }

    private Future<BulkEntityIterable> uploadEntitiesAsyncImpl(FileUploadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        final ResultFuture<BulkEntityIterable> resultFuture = new ResultFuture<BulkEntityIterable>(callback);
        this.uploadFileAsyncImpl(parameters, progress, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File resultFile) throws IOException {
                resultFuture.setResult(BulkServiceManager.this.bulkFileReaderFactory.createBulkFileReader(resultFile, ResultFileType.UPLOAD, DownloadFileType.CSV).getEntities());
            }
        });
        return resultFuture;
    }

    private Future<File> uploadFileAsyncImpl(final FileUploadParameters parameters, final Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        this.workingDirectory.mkdirs();
        this.submitUploadAsync(parameters, (AsyncCallback<BulkUploadOperation>)new ParentCallback<BulkUploadOperation>(resultFuture){

            @Override
            public void onSuccess(final BulkUploadOperation operation) {
                operation.trackAsync(progress, new ParentCallback<BulkOperationStatus<UploadStatus>>(resultFuture){

                    @Override
                    public void onSuccess(BulkOperationStatus<UploadStatus> status) throws IOException, URISyntaxException {
                        BulkServiceManager.this.downloadBulkFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                            @Override
                            public void onSuccess(File localFile) {
                                resultFuture.setResult(localFile);
                            }
                        });
                    }
                });
            }
        });
        return resultFuture;
    }

    private void validateSubmitDownloadParameters(SubmitDownloadParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
    }

    private Future<BulkEntityIterable> downloadEntitiesAsyncImpl(final DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkEntityIterable> callback) {
        final ResultFuture<BulkEntityIterable> resultFuture = new ResultFuture<BulkEntityIterable>(callback);
        this.downloadFileAsyncImpl(parameters, progress, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File result) throws IOException {
                ResultFileType resultFileType = parameters.getLastSyncTimeInUTC() != null ? ResultFileType.PARTIAL_DOWNLOAD : ResultFileType.FULL_DOWNLOAD;
                BulkFileReader reader = BulkServiceManager.this.bulkFileReaderFactory.createBulkFileReader(result, resultFileType, parameters.getFileType());
                resultFuture.setResult(reader.getEntities());
            }
        });
        return resultFuture;
    }

    public Future<File> downloadFileAsync(DownloadParameters parameters, AsyncCallback<File> callback) {
        return this.downloadFileAsync(parameters, null, callback);
    }

    public Future<File> downloadFileAsync(DownloadParameters parameters, Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        this.validateUserData();
        this.validateSubmitDownloadParameters(parameters.getSubmitDownloadParameters());
        return this.downloadFileAsyncImpl(parameters, progress, callback);
    }

    private Future<File> downloadFileAsyncImpl(final DownloadParameters parameters, final Progress<BulkOperationProgressInfo> progress, AsyncCallback<File> callback) {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        this.workingDirectory.mkdirs();
        this.submitDownloadAsync(parameters.getSubmitDownloadParameters(), (AsyncCallback<BulkDownloadOperation>)new ParentCallback<BulkDownloadOperation>(resultFuture){

            @Override
            public void onSuccess(final BulkDownloadOperation operation) {
                operation.trackAsync(progress, new ParentCallback<BulkOperationStatus<DownloadStatus>>(resultFuture){

                    @Override
                    public void onSuccess(BulkOperationStatus<DownloadStatus> status) throws IOException, URISyntaxException {
                        BulkServiceManager.this.downloadBulkFileAsync(parameters.getResultFileDirectory(), parameters.getResultFileName(), parameters.getOverwriteResultFile(), operation, new ParentCallback<File>(resultFuture){

                            @Override
                            public void onSuccess(File localFile) {
                                resultFuture.setResult(localFile);
                            }
                        });
                    }
                });
            }
        });
        return resultFuture;
    }

    private <T> Future<File> downloadBulkFileAsync(File resultFileDirectory, String resultFileName, boolean overwriteResultFile, BulkOperation<T> operation, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        operation.setHttpFileService(this.httpFileService);
        operation.setZipExtractor(this.zipExtractor);
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        File effectiveResultFileDirectory = resultFileDirectory;
        if (effectiveResultFileDirectory == null) {
            effectiveResultFileDirectory = this.workingDirectory;
        }
        operation.downloadResultFileAsync(effectiveResultFileDirectory, resultFileName, true, overwriteResultFile, (AsyncCallback<File>)new ParentCallback<File>(resultFuture){

            @Override
            public void onSuccess(File file) {
                resultFuture.setResult(file);
            }
        });
        return resultFuture;
    }

    private void validateUserData() {
        this.authorizationData.validate();
    }

    public Future<BulkDownloadOperation> submitDownloadAsync(SubmitDownloadParameters parameters, AsyncCallback<BulkDownloadOperation> callback) {
        Authentication auth = this.authorizationData.getAuthentication();
        if (auth == null) {
            throw new IllegalArgumentException("Missing authentication");
        }
        final ResultFuture<BulkDownloadOperation> resultFuture = new ResultFuture<BulkDownloadOperation>(callback);
        if (parameters.getCampaignIds() == null) {
            DownloadCampaignsByAccountIdsRequest request = this.generateCampaignsByAccountIdRequest(parameters);
            IBulkService service = this.serviceClient.getService();
            service.downloadCampaignsByAccountIdsAsync(request, new AsyncHandler<DownloadCampaignsByAccountIdsResponse>(){

                public void handleResponse(Response<DownloadCampaignsByAccountIdsResponse> res) {
                    try {
                        DownloadCampaignsByAccountIdsResponse response = (DownloadCampaignsByAccountIdsResponse)res.get();
                        String trackingId = ServiceUtils.GetTrackingId(res);
                        BulkDownloadOperation operation = new BulkDownloadOperation(response.getDownloadRequestId(), BulkServiceManager.this.authorizationData, trackingId, BulkServiceManager.this.apiEnvironment);
                        operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                        resultFuture.setResult(operation);
                    }
                    catch (InterruptedException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                    catch (ExecutionException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                }
            });
        } else {
            DownloadCampaignsByCampaignIdsRequest request = this.generateCampaignsByCampaignIdsRequest(parameters);
            IBulkService service = this.serviceClient.getService();
            service.downloadCampaignsByCampaignIdsAsync(request, new AsyncHandler<DownloadCampaignsByCampaignIdsResponse>(){

                public void handleResponse(Response<DownloadCampaignsByCampaignIdsResponse> res) {
                    try {
                        DownloadCampaignsByCampaignIdsResponse response = (DownloadCampaignsByCampaignIdsResponse)res.get();
                        BulkDownloadOperation operation = new BulkDownloadOperation(response.getDownloadRequestId(), BulkServiceManager.this.authorizationData, ServiceUtils.GetTrackingId(res), BulkServiceManager.this.apiEnvironment);
                        operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                        resultFuture.setResult(operation);
                    }
                    catch (InterruptedException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                    catch (ExecutionException e) {
                        resultFuture.setException(new CouldNotSubmitBulkDownloadException(e));
                    }
                }
            });
        }
        return resultFuture;
    }

    public Future<BulkUploadOperation> submitUploadAsync(final FileUploadParameters parameters, AsyncCallback<BulkUploadOperation> callback) {
        GetBulkUploadUrlRequest request = new GetBulkUploadUrlRequest();
        request.setResponseMode(parameters.getResponseMode());
        request.setAccountId(this.authorizationData.getAccountId());
        final ResultFuture<BulkUploadOperation> resultFuture = new ResultFuture<BulkUploadOperation>(callback);
        final IBulkService service = this.serviceClient.getService();
        service.getBulkUploadUrlAsync(request, new AsyncHandler<GetBulkUploadUrlResponse>(){

            public void handleResponse(Response<GetBulkUploadUrlResponse> res) {
                try {
                    GetBulkUploadUrlResponse response = (GetBulkUploadUrlResponse)res.get();
                    String trackingId = ServiceUtils.GetTrackingId(res);
                    String uploadUrl = response.getUploadUrl();
                    File effectiveUploadPath = parameters.getUploadFilePath();
                    boolean shouldCompress = parameters.getCompressUploadFile() && !StringExtensions.getFileExtension(effectiveUploadPath.toString()).equals(".zip");
                    File compressedFilePath = null;
                    if (shouldCompress) {
                        effectiveUploadPath = compressedFilePath = BulkServiceManager.this.compressUploadFile(effectiveUploadPath);
                    }
                    Consumer<HttpRequest> addHeaders = new Consumer<HttpRequest>(){

                        @Override
                        public void accept(final HttpRequest request) {
                            request.addHeader("DeveloperToken", BulkServiceManager.this.authorizationData.getDeveloperToken());
                            request.addHeader("CustomerId", Long.toString(BulkServiceManager.this.authorizationData.getCustomerId()));
                            request.addHeader("AccountId", Long.toString(BulkServiceManager.this.authorizationData.getAccountId()));
                            BulkServiceManager.this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

                                @Override
                                public void addHeader(String name, String value) {
                                    request.addHeader(name, value);
                                }
                            });
                        }
                    };
                    BulkServiceManager.this.httpFileService.uploadFile(new URI(uploadUrl), effectiveUploadPath, addHeaders);
                    if (shouldCompress) {
                        compressedFilePath.delete();
                    }
                    BulkUploadOperation operation = new BulkUploadOperation(response.getRequestId(), BulkServiceManager.this.authorizationData, service, trackingId, BulkServiceManager.this.apiEnvironment);
                    operation.setStatusPollIntervalInMilliseconds(BulkServiceManager.this.statusPollIntervalInMilliseconds);
                    resultFuture.setResult(operation);
                }
                catch (InterruptedException e) {
                    resultFuture.setException(new CouldNotSubmitBulkUploadException(e));
                }
                catch (ExecutionException e) {
                    resultFuture.setException(new CouldNotSubmitBulkUploadException(e));
                }
                catch (URISyntaxException e) {
                    resultFuture.setException(e);
                }
                catch (CouldNotUploadFileException e) {
                    resultFuture.setException(e);
                }
            }
        });
        return resultFuture;
    }

    private File compressUploadFile(File uploadFilePath) {
        this.workingDirectory.mkdirs();
        File compressedFilePath = new File(this.workingDirectory, StringExtensions.getFileNameWithoutExtension(uploadFilePath) + "_" + UUID.randomUUID() + ".zip");
        this.zipExtractor.compressFile(uploadFilePath, compressedFilePath);
        return compressedFilePath;
    }

    public void cleanupTempFiles() {
        for (File file : this.workingDirectory.listFiles()) {
            file.delete();
        }
    }

    private DownloadCampaignsByCampaignIdsRequest generateCampaignsByCampaignIdsRequest(SubmitDownloadParameters parameters) {
        DownloadCampaignsByCampaignIdsRequest request = new DownloadCampaignsByCampaignIdsRequest();
        ArrayOfCampaignScope arrayOfCampaigns = new ArrayOfCampaignScope();
        List<CampaignScope> campaigns = arrayOfCampaigns.getCampaignScopes();
        for (Long campaignId : parameters.getCampaignIds()) {
            CampaignScope scope = new CampaignScope();
            scope.setCampaignId(campaignId);
            scope.setParentAccountId(this.authorizationData.getAccountId());
            campaigns.add(scope);
        }
        request.setCampaigns(arrayOfCampaigns);
        request.setDataScope(parameters.getDataScope());
        request.setDownloadFileType(parameters.getFileType());
        request.setEntities(parameters.getEntities());
        request.setFormatVersion(FORMAT_VERSION);
        request.setLastSyncTimeInUTC(parameters.getLastSyncTimeInUTC());
        request.setPerformanceStatsDateRange(parameters.getPerformanceStatsDateRange());
        return request;
    }

    private DownloadCampaignsByAccountIdsRequest generateCampaignsByAccountIdRequest(SubmitDownloadParameters parameters) {
        DownloadCampaignsByAccountIdsRequest request = new DownloadCampaignsByAccountIdsRequest();
        ArrayOflong accountIds = new ArrayOflong();
        accountIds.getLongs().add(this.authorizationData.getAccountId());
        request.setAccountIds(accountIds);
        request.setDataScope(parameters.getDataScope());
        request.setDownloadFileType(parameters.getFileType());
        request.setEntities(parameters.getEntities());
        request.setFormatVersion(FORMAT_VERSION);
        request.setLastSyncTimeInUTC(parameters.getLastSyncTimeInUTC());
        request.setPerformanceStatsDateRange(parameters.getPerformanceStatsDateRange());
        return request;
    }

    private FileUploadParameters createFileUploadParameters(EntityUploadParameters parameters) {
        this.workingDirectory.mkdirs();
        File tempFilePath = new File(this.getWorkingDirectory(), UUID.randomUUID() + ".csv");
        BulkFileWriter writer = null;
        try {
            writer = new BulkFileWriter(tempFilePath);
            for (BulkEntity entity : parameters.getEntities()) {
                writer.writeEntity(entity);
            }
        }
        catch (IOException ex) {
            throw new InternalException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new InternalException(ex);
                }
            }
        }
        FileUploadParameters fileUploadParameters = new FileUploadParameters();
        fileUploadParameters.setUploadFilePath(tempFilePath);
        fileUploadParameters.setResponseMode(parameters.getResponseMode());
        fileUploadParameters.setResultFileDirectory(parameters.getResultFileDirectory());
        fileUploadParameters.setResultFileName(parameters.getResultFileName());
        fileUploadParameters.setOverwriteResultFile(parameters.getOverwriteResultFile());
        return fileUploadParameters;
    }

    public HttpFileService getHttpFileService() {
        return this.httpFileService;
    }

    public void setHttpFileService(HttpFileService httpFileService) {
        this.httpFileService = httpFileService;
    }

    public ZipExtractor getZipExtractor() {
        return this.zipExtractor;
    }

    public void setZipExtractor(ZipExtractor zipExtractor) {
        this.zipExtractor = zipExtractor;
    }

    public BulkFileReaderFactory getBulkFileReaderFactory() {
        return this.bulkFileReaderFactory;
    }

    public void setBulkFileReaderFactory(BulkFileReaderFactory bulkFileReaderFactory) {
        this.bulkFileReaderFactory = bulkFileReaderFactory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File value) {
        this.workingDirectory = value;
    }

    public int getStatusPollIntervalInMilliseconds() {
        return this.statusPollIntervalInMilliseconds;
    }

    public void setStatusPollIntervalInMilliseconds(int statusPollIntervalInMilliseconds) {
        this.statusPollIntervalInMilliseconds = statusPollIntervalInMilliseconds;
    }
}

