/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.v10.bulk.entities.BulkCampaignNegativeSite;
import com.microsoft.bingads.v10.bulk.entities.BulkNegativeSites;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v10.campaignmanagement.CampaignNegativeSites;
import com.microsoft.bingads.v10.internal.bulk.entities.BulkCampaignNegativeSitesIdentifier;
import java.util.ArrayList;
import java.util.List;

public class BulkCampaignNegativeSites
extends BulkNegativeSites<BulkCampaignNegativeSite, BulkCampaignNegativeSitesIdentifier> {
    private CampaignNegativeSites campaignNegativeSites;
    private String campaignName;

    public CampaignNegativeSites getCampaignNegativeSites() {
        return this.campaignNegativeSites;
    }

    public void setCampaignNegativeSites(CampaignNegativeSites campaignNegativeSites) {
        this.campaignNegativeSites = campaignNegativeSites;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public BulkCampaignNegativeSites() {
    }

    BulkCampaignNegativeSites(BulkCampaignNegativeSite site) {
        super(site, BulkCampaignNegativeSite.class, BulkCampaignNegativeSitesIdentifier.class);
        this.setDataFromIdentifier((BulkCampaignNegativeSitesIdentifier)site.getIdentifier());
    }

    public BulkCampaignNegativeSites(BulkCampaignNegativeSitesIdentifier identifier) {
        super(identifier, BulkCampaignNegativeSite.class, BulkCampaignNegativeSitesIdentifier.class);
        this.setDataFromIdentifier(identifier);
    }

    private void setDataFromIdentifier(BulkCampaignNegativeSitesIdentifier identifier) {
        this.campaignNegativeSites = new CampaignNegativeSites();
        this.campaignNegativeSites.setCampaignId(identifier.getCampaignId());
        this.campaignName = identifier.getCampaignName();
    }

    @Override
    protected Iterable<BulkCampaignNegativeSite> convertApiToBulkNegativeSites() {
        this.validateListNotNullOrEmpty(this.campaignNegativeSites.getNegativeSites(), this.campaignNegativeSites.getNegativeSites().getStrings(), "CampaignNegativeSites.NegativeSites");
        ArrayList<BulkCampaignNegativeSite> bulkSites = new ArrayList<BulkCampaignNegativeSite>();
        List<String> negativeSites = this.campaignNegativeSites.getNegativeSites().getStrings();
        for (String negativeSite : negativeSites) {
            BulkCampaignNegativeSite bulkSite = new BulkCampaignNegativeSite();
            if (this.campaignNegativeSites.getCampaignId() != null) {
                bulkSite.setCampaignId(this.campaignNegativeSites.getCampaignId());
            }
            bulkSite.setWebsite(negativeSite);
            bulkSite.setCampaignName(this.getCampaignName());
            bulkSites.add(bulkSite);
        }
        return bulkSites;
    }

    @Override
    protected void reconstructApiObjects() {
        ArrayOfstring websitesArray = new ArrayOfstring();
        for (BulkCampaignNegativeSite bulkNegativeSite : this.getNegativeSites()) {
            websitesArray.getStrings().add(bulkNegativeSite.getWebsite());
        }
        this.campaignNegativeSites.setNegativeSites(websitesArray);
    }

    @Override
    protected BulkCampaignNegativeSitesIdentifier createIdentifier() {
        BulkCampaignNegativeSitesIdentifier identifier = new BulkCampaignNegativeSitesIdentifier();
        if (this.campaignNegativeSites.getCampaignId() != null) {
            identifier.setCampaignId(this.campaignNegativeSites.getCampaignId());
        }
        identifier.setCampaignName(this.campaignName);
        return identifier;
    }

    @Override
    protected void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.campaignNegativeSites, "CampaignNegativeSites");
    }
}

