/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.azure.data.cosmos.CosmosResponseDiagnostics;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.FeedResponseDiagnostics;
import com.azure.data.cosmos.Resource;

public class ResponseDiagnostics {
    private CosmosResponseDiagnostics cosmosResponseDiagnostics;
    private FeedResponseDiagnostics feedResponseDiagnostics;
    private CosmosResponseStatistics cosmosResponseStatistics;

    public ResponseDiagnostics(CosmosResponseDiagnostics cosmosResponseDiagnostics, FeedResponseDiagnostics feedResponseDiagnostics) {
        this.cosmosResponseDiagnostics = cosmosResponseDiagnostics;
        this.feedResponseDiagnostics = feedResponseDiagnostics;
    }

    public ResponseDiagnostics(CosmosResponseDiagnostics cosmosResponseDiagnostics, FeedResponseDiagnostics feedResponseDiagnostics, CosmosResponseStatistics cosmosResponseStatistics) {
        this.cosmosResponseDiagnostics = cosmosResponseDiagnostics;
        this.feedResponseDiagnostics = feedResponseDiagnostics;
        this.cosmosResponseStatistics = cosmosResponseStatistics;
    }

    public String toString() {
        StringBuilder diagnostics = new StringBuilder();
        if (this.cosmosResponseDiagnostics != null) {
            diagnostics.append("cosmosResponseDiagnostics={").append(this.cosmosResponseDiagnostics).append("}");
        }
        if (this.feedResponseDiagnostics != null) {
            if (diagnostics.length() != 0) {
                diagnostics.append(", ");
            }
            diagnostics.append("feedResponseDiagnostics={").append(this.feedResponseDiagnostics).append("}");
        }
        if (this.cosmosResponseStatistics != null) {
            if (diagnostics.length() != 0) {
                diagnostics.append(", ");
            }
            diagnostics.append("cosmosResponseStatistics={").append(this.cosmosResponseStatistics).append("}");
        }
        return diagnostics.toString();
    }

    public CosmosResponseDiagnostics getCosmosResponseDiagnostics() {
        return this.cosmosResponseDiagnostics;
    }

    public FeedResponseDiagnostics getFeedResponseDiagnostics() {
        return this.feedResponseDiagnostics;
    }

    public CosmosResponseStatistics getCosmosResponseStatistics() {
        return this.cosmosResponseStatistics;
    }

    public void setCosmosResponseDiagnostics(CosmosResponseDiagnostics cosmosResponseDiagnostics) {
        this.cosmosResponseDiagnostics = cosmosResponseDiagnostics;
    }

    public void setFeedResponseDiagnostics(FeedResponseDiagnostics feedResponseDiagnostics) {
        this.feedResponseDiagnostics = feedResponseDiagnostics;
    }

    public void setCosmosResponseStatistics(CosmosResponseStatistics cosmosResponseStatistics) {
        this.cosmosResponseStatistics = cosmosResponseStatistics;
    }

    public static class CosmosResponseStatistics {
        private final double requestCharge;
        private final String activityId;

        public <T extends Resource> CosmosResponseStatistics(FeedResponse<T> feedResponse) {
            this.requestCharge = feedResponse.requestCharge();
            this.activityId = feedResponse.activityId();
        }

        public String toString() {
            return "CosmosResponseStatistics{requestCharge=" + this.requestCharge + ", activityId='" + this.activityId + '\'' + '}';
        }

        public double getRequestCharge() {
            return this.requestCharge;
        }

        public String getActivityId() {
            return this.activityId;
        }
    }
}

