/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.generator;

import com.azure.data.cosmos.SqlParameter;
import com.azure.data.cosmos.SqlParameterList;
import com.azure.data.cosmos.SqlQuerySpec;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingCosmosConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.IllegalQueryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractQueryGenerator {
    private String generateQueryParameter(@NonNull String subject) {
        return subject.replaceAll("\\.", "_");
    }

    private String generateUnaryQuery(@NonNull Criteria criteria) {
        Assert.isTrue((boolean)criteria.getSubjectValues().isEmpty(), (String)"Unary criteria should have no one subject value");
        Assert.isTrue((boolean)CriteriaType.isUnary(criteria.getType()), (String)"Criteria type should be unary operation");
        String subject = criteria.getSubject();
        if (CriteriaType.isFunction(criteria.getType())) {
            return String.format("%s(r.%s)", criteria.getType().getSqlKeyword(), subject);
        }
        return String.format("r.%s %s", subject, criteria.getType().getSqlKeyword());
    }

    private String generateBinaryQuery(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Binary criteria should have only one subject value");
        Assert.isTrue((boolean)CriteriaType.isBinary(criteria.getType()), (String)"Criteria type should be binary operation");
        String subject = criteria.getSubject();
        Object subjectValue = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        String parameter = this.generateQueryParameter(subject);
        parameters.add((Pair<String, Object>)Pair.with((Object)parameter, (Object)subjectValue));
        if (CriteriaType.isFunction(criteria.getType())) {
            return String.format("%s(r.%s, @%s)", criteria.getType().getSqlKeyword(), subject, parameter);
        }
        return String.format("r.%s %s @%s", subject, criteria.getType().getSqlKeyword(), parameter);
    }

    private String generateBetween(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        String subject = criteria.getSubject();
        Object value1 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        Object value2 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(1));
        String subject1 = "start";
        String subject2 = "end";
        String parameter1 = this.generateQueryParameter("start");
        String parameter2 = this.generateQueryParameter("end");
        String keyword = criteria.getType().getSqlKeyword();
        parameters.add((Pair<String, Object>)Pair.with((Object)parameter1, (Object)value1));
        parameters.add((Pair<String, Object>)Pair.with((Object)parameter2, (Object)value2));
        return String.format("(r.%s %s @%s AND @%s)", subject, keyword, parameter1, parameter2);
    }

    private String generateClosedQuery(@NonNull String left, @NonNull String right, CriteriaType type) {
        Assert.isTrue((CriteriaType.isClosed(type) && CriteriaType.isBinary(type) ? 1 : 0) != 0, (String)"Criteria type should be binary and closure operation");
        return String.join((CharSequence)" ", left, type.getSqlKeyword(), right);
    }

    private String generateInQuery(Criteria criteria) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Criteria should have only one subject value");
        if (!(criteria.getSubjectValues().get(0) instanceof Collection)) {
            throw new IllegalQueryException("IN keyword requires Collection type in parameters");
        }
        ArrayList inRangeValues = new ArrayList();
        Collection values = (Collection)criteria.getSubjectValues().get(0);
        values.forEach(o -> {
            if (o instanceof Integer || o instanceof Long) {
                inRangeValues.add(String.format("%d", o));
            } else if (o instanceof String) {
                inRangeValues.add(String.format("'%s'", (String)o));
            } else if (o instanceof Boolean) {
                inRangeValues.add(String.format("%b", (Boolean)o));
            } else {
                throw new IllegalQueryException("IN keyword Range only support Number and String type.");
            }
        });
        String inRange = String.join((CharSequence)",", inRangeValues);
        return String.format("r.%s %s (%s)", criteria.getSubject(), criteria.getType().getSqlKeyword(), inRange);
    }

    private String generateQueryBody(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        CriteriaType type = criteria.getType();
        switch (type) {
            case ALL: {
                return "";
            }
            case IN: 
            case NOT_IN: {
                return this.generateInQuery(criteria);
            }
            case BETWEEN: {
                return this.generateBetween(criteria, parameters);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case FALSE: 
            case TRUE: {
                return this.generateUnaryQuery(criteria);
            }
            case IS_EQUAL: 
            case NOT: 
            case BEFORE: 
            case AFTER: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case CONTAINING: 
            case ENDS_WITH: 
            case STARTS_WITH: {
                return this.generateBinaryQuery(criteria, parameters);
            }
            case AND: 
            case OR: {
                Assert.isTrue((criteria.getSubCriteria().size() == 2 ? 1 : 0) != 0, (String)"criteria should have two SubCriteria");
                String left = this.generateQueryBody(criteria.getSubCriteria().get(0), parameters);
                String right = this.generateQueryBody(criteria.getSubCriteria().get(1), parameters);
                return this.generateClosedQuery(left, right, type);
            }
        }
        throw new UnsupportedOperationException("unsupported Criteria type: " + (Object)((Object)type));
    }

    @NonNull
    private Pair<String, List<Pair<String, Object>>> generateQueryBody(@NonNull DocumentQuery query) {
        ArrayList<Pair<String, Object>> parameters = new ArrayList<Pair<String, Object>>();
        String queryString = this.generateQueryBody(query.getCriteria(), parameters);
        if (StringUtils.hasText((String)queryString)) {
            queryString = String.join((CharSequence)" ", "WHERE", queryString);
        }
        return Pair.with((Object)queryString, parameters);
    }

    private String getParameter(@NonNull Sort.Order order) {
        Assert.isTrue((!order.isIgnoreCase() ? 1 : 0) != 0, (String)"Ignore case is not supported");
        String direction = order.isDescending() ? "DESC" : "ASC";
        return String.format("r.%s %s", order.getProperty(), direction);
    }

    private String generateQuerySort(@NonNull Sort sort) {
        if (sort.isUnsorted()) {
            return "";
        }
        String queryTail = "ORDER BY";
        List subjects = sort.stream().map(this::getParameter).collect(Collectors.toList());
        return "ORDER BY " + String.join((CharSequence)",", subjects);
    }

    @NonNull
    private String generateQueryTail(@NonNull DocumentQuery query) {
        ArrayList<String> queryTails = new ArrayList<String>();
        queryTails.add(this.generateQuerySort(query.getSort()));
        return String.join((CharSequence)" ", queryTails.stream().filter(StringUtils::hasText).collect(Collectors.toList()));
    }

    protected SqlQuerySpec generateCosmosQuery(@NonNull DocumentQuery query, @NonNull String queryHead) {
        Pair<String, List<Pair<String, Object>>> queryBody = this.generateQueryBody(query);
        String queryString = String.join((CharSequence)" ", queryHead, (CharSequence)queryBody.getValue0(), this.generateQueryTail(query));
        List parameters = (List)queryBody.getValue1();
        SqlParameterList sqlParameters = new SqlParameterList();
        sqlParameters.addAll((Collection)parameters.stream().map(p -> new SqlParameter("@" + (String)p.getValue0(), MappingCosmosConverter.toCosmosDbValue(p.getValue1()))).collect(Collectors.toList()));
        return new SqlQuerySpec(queryString, sqlParameters);
    }

    protected AbstractQueryGenerator() {
    }
}

