/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.UnauthorizedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MultiplexingDeviceUnauthorizedException
extends UnauthorizedException {
    private Map<String, Exception> registrationExceptions = new HashMap<String, Exception>();

    public MultiplexingDeviceUnauthorizedException() {
        this.isRetryable = false;
    }

    public MultiplexingDeviceUnauthorizedException(String message) {
        super(message);
        this.isRetryable = false;
    }

    public MultiplexingDeviceUnauthorizedException(String message, Throwable cause) {
        super(message, cause);
        this.isRetryable = false;
    }

    public MultiplexingDeviceUnauthorizedException(Throwable cause) {
        super(cause);
        this.isRetryable = false;
    }

    public void addRegistrationException(String deviceId, Exception registrationException) {
        Objects.requireNonNull(registrationException, "registrationException cannot be null");
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        this.registrationExceptions.put(deviceId, registrationException);
    }

    public Map<String, Exception> getRegistrationExceptions() {
        return this.registrationExceptions;
    }

    public void setRegistrationExceptionsMap(Map<String, Exception> registrationExceptions) {
        this.registrationExceptions = registrationExceptions;
    }
}

