/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.transport.RetryDecision;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoffWithJitter
implements RetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackoffWithJitter.class);
    private int retryCount = Integer.MAX_VALUE;
    private long minBackoff = 100L;
    private long maxBackoff = 10000L;
    private long deltaBackoff = 100L;
    private boolean firstFastRetry = true;
    private final SecureRandom random = new SecureRandom();

    public ExponentialBackoffWithJitter() {
        this.logCreation();
    }

    public ExponentialBackoffWithJitter(int retryCount, long minBackoff, long maxBackoff, long deltaBackoff, boolean firstFastRetry) {
        if (retryCount <= 0) {
            throw new IllegalArgumentException("retryCount cannot be less than or equal to 0.");
        }
        this.retryCount = retryCount;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.deltaBackoff = deltaBackoff;
        this.firstFastRetry = firstFastRetry;
        this.logCreation();
    }

    @Override
    public RetryDecision getRetryDecision(int currentRetryCount, TransportException lastException) {
        if (currentRetryCount == 0 && this.firstFastRetry) {
            return new RetryDecision(true, 0L);
        }
        if (currentRetryCount < this.retryCount) {
            int deltaBackoffLowbound = (int)((double)this.deltaBackoff * 0.8);
            int deltaBackoffUpperbound = (int)((double)this.deltaBackoff * 1.2);
            long randomDeltaBackOff = this.random.nextInt(deltaBackoffUpperbound - deltaBackoffLowbound);
            long exponentialBackOffWithJitter = (int)((Math.pow(2.0, currentRetryCount) - 1.0) * (double)(randomDeltaBackOff + (long)deltaBackoffLowbound));
            long finalWaitTimeUntilNextRetry = (int)Math.min((double)this.minBackoff + (double)exponentialBackOffWithJitter, (double)this.maxBackoff);
            return new RetryDecision(true, finalWaitTimeUntilNextRetry);
        }
        return new RetryDecision(false, 0L);
    }

    private void logCreation() {
        log.info("NOTE: A new instance of ExponentialBackoffWithJitter has been created with the following properties. Retry Count: {}, Min Backoff Interval: {}, Max Backoff Interval: {}, Max Time Between Retries: {}, Fast Retry Enabled: {}", new Object[]{this.retryCount, this.minBackoff, this.maxBackoff, this.deltaBackoff, this.firstFastRetry});
    }
}

