/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSSLContext;
import java.io.IOException;
import java.util.Objects;
import javax.net.ssl.SSLContext;

public abstract class IotHubAuthenticationProvider {
    protected String hostname;
    protected final String gatewayHostname;
    protected String deviceId;
    protected final String moduleId;
    IotHubSSLContext iotHubSSLContext;

    public IotHubAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId) {
        this(hostname, gatewayHostname, deviceId, moduleId, null);
    }

    public IotHubAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, SSLContext sslContext) {
        Objects.requireNonNull(hostname);
        Objects.requireNonNull(deviceId);
        this.hostname = hostname;
        this.gatewayHostname = gatewayHostname;
        this.deviceId = deviceId;
        this.moduleId = moduleId;
        this.iotHubSSLContext = sslContext == null ? new IotHubSSLContext() : new IotHubSSLContext(sslContext);
    }

    public SSLContext getSSLContext() throws IOException {
        return this.iotHubSSLContext.getSSLContext();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getGatewayHostname() {
        return this.gatewayHostname;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }
}

