/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.BadFormatException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.HubOrDeviceIdNotFoundException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.InternalServerErrorException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.PreconditionFailedException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.QuotaExceededException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.RequestEntityTooLargeException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.ServerBusyException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.ServiceUnknownException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.ThrottledException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.UnauthorizedException;

public enum IotHubStatusCode {
    OK,
    BAD_FORMAT,
    UNAUTHORIZED,
    QUOTA_EXCEEDED,
    NOT_FOUND,
    PRECONDITION_FAILED,
    REQUEST_ENTITY_TOO_LARGE,
    THROTTLED,
    INTERNAL_SERVER_ERROR,
    SERVER_BUSY,
    ERROR,
    MESSAGE_EXPIRED,
    MESSAGE_CANCELLED_ONCLOSE,
    IO_ERROR,
    DEVICE_OPERATION_TIMED_OUT;


    public static IotHubServiceException getConnectionStatusException(IotHubStatusCode statusCode, String statusDescription) {
        IotHubServiceException transportException;
        switch (statusCode) {
            case OK: 
            case MESSAGE_CANCELLED_ONCLOSE: 
            case MESSAGE_EXPIRED: {
                transportException = null;
                break;
            }
            case BAD_FORMAT: {
                transportException = new BadFormatException(statusDescription);
                break;
            }
            case UNAUTHORIZED: {
                transportException = new UnauthorizedException(statusDescription);
                break;
            }
            case QUOTA_EXCEEDED: {
                transportException = new QuotaExceededException(statusDescription);
                break;
            }
            case NOT_FOUND: {
                transportException = new HubOrDeviceIdNotFoundException(statusDescription);
                break;
            }
            case PRECONDITION_FAILED: {
                transportException = new PreconditionFailedException(statusDescription);
                break;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                transportException = new RequestEntityTooLargeException(statusDescription);
                break;
            }
            case THROTTLED: {
                transportException = new ThrottledException(statusDescription);
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                transportException = new InternalServerErrorException(statusDescription);
                break;
            }
            case SERVER_BUSY: {
                transportException = new ServerBusyException(statusDescription);
                break;
            }
            case ERROR: {
                transportException = new ServiceUnknownException("Service gave unknown status code: " + (Object)((Object)statusCode));
                break;
            }
            default: {
                transportException = new IotHubServiceException("Service gave unknown status code: " + (Object)((Object)statusCode));
            }
        }
        return transportException;
    }

    public static IotHubStatusCode getIotHubStatusCode(int httpsStatus) {
        IotHubStatusCode iotHubStatus;
        switch (httpsStatus) {
            case 200: 
            case 204: {
                iotHubStatus = OK;
                break;
            }
            case 400: {
                iotHubStatus = BAD_FORMAT;
                break;
            }
            case 401: {
                iotHubStatus = UNAUTHORIZED;
                break;
            }
            case 403: {
                iotHubStatus = QUOTA_EXCEEDED;
                break;
            }
            case 404: {
                iotHubStatus = NOT_FOUND;
                break;
            }
            case 412: {
                iotHubStatus = PRECONDITION_FAILED;
                break;
            }
            case 413: {
                iotHubStatus = REQUEST_ENTITY_TOO_LARGE;
                break;
            }
            case 429: {
                iotHubStatus = THROTTLED;
                break;
            }
            case 500: {
                iotHubStatus = INTERNAL_SERVER_ERROR;
                break;
            }
            case 503: {
                iotHubStatus = SERVER_BUSY;
                break;
            }
            default: {
                iotHubStatus = ERROR;
            }
        }
        return iotHubStatus;
    }

    public static boolean isRetryable(IotHubStatusCode statusCode) {
        switch (statusCode) {
            case MESSAGE_CANCELLED_ONCLOSE: 
            case MESSAGE_EXPIRED: 
            case THROTTLED: 
            case INTERNAL_SERVER_ERROR: 
            case SERVER_BUSY: 
            case ERROR: 
            case IO_ERROR: 
            case DEVICE_OPERATION_TIMED_OUT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuccessful(IotHubStatusCode statusCode) {
        return statusCode == OK;
    }

    public static IotHubClientException toException(IotHubStatusCode statusCode) {
        if (!IotHubStatusCode.isSuccessful(statusCode)) {
            return new IotHubClientException(statusCode);
        }
        return null;
    }
}

