/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.format;

import com.microsoft.azure.kusto.data.ClientRequestProperties;
import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.format.CslFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;

public class CslTimespanFormat
extends CslFormat {
    public static final String KUSTO_TIMESPAN_PATTERN = "HH:mm:ss.SSSSSSS";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSS");
    private final Duration value;

    public CslTimespanFormat(Duration value) {
        this.value = value;
    }

    public CslTimespanFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.value = null;
        } else {
            Matcher matcher = ClientRequestProperties.KUSTO_TIMESPAN_REGEX.matcher(value);
            if (!matcher.matches()) {
                throw new ParseException(String.format("Failed to parse timeout string as a timespan. Value: %s", value));
            }
            long nanos = 0L;
            String days = matcher.group(2);
            if (days != null && !days.equals("0")) {
                nanos = TimeUnit.DAYS.toNanos(Integer.parseInt(days));
            }
            String timespanWithoutDays = "";
            for (int i = 4; i <= 10; ++i) {
                if (matcher.group(i) == null) continue;
                timespanWithoutDays = timespanWithoutDays + matcher.group(i);
            }
            this.value = "-".equals(matcher.group(1)) ? Duration.ofNanos(nanos).negated() : Duration.ofNanos(nanos += LocalTime.parse(timespanWithoutDays).toNanoOfDay());
        }
    }

    @Override
    public String getType() {
        return "time";
    }

    @Override
    public Duration getValue() {
        return this.value;
    }

    @Override
    String getValueAsString() {
        Duration valueWithoutDays;
        Ensure.argIsNotNull(this.value, "value");
        String result = "";
        Duration duration = valueWithoutDays = this.value.isNegative() ? this.value.negated() : this.value;
        if (valueWithoutDays.toDays() > 0L) {
            result = result + valueWithoutDays.toDays() + ".";
            valueWithoutDays = valueWithoutDays.minusDays(valueWithoutDays.toDays());
        }
        result = result + LocalTime.MIDNIGHT.plus(valueWithoutDays).format(DATE_TIME_FORMATTER);
        if (this.value.isNegative()) {
            result = "-" + result;
        }
        return result;
    }
}

