/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.azure.kusto.data.auth.PublicAppTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserPromptTokenProvider
extends PublicAppTokenProviderBase {
    private static final int USER_PROMPT_TIMEOUT_MS = 120000;
    private static final URI redirectUri;
    public static final String USER_PROMPT_TOKEN_PROVIDER = "UserPromptTokenProvider";
    private final String usernameHint;

    UserPromptTokenProvider(@NotNull String clusterUrl, @Nullable String usernameHint, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, authorityId, httpClient);
        this.usernameHint = usernameHint;
    }

    @Override
    protected IAuthenticationResult acquireNewAccessToken() throws DataServiceException, DataClientException {
        IAuthenticationResult result;
        try {
            this.clientApplication = ((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.clientAppId).authority(this.aadAuthorityUrl)).build();
            CompletableFuture future = this.clientApplication.acquireToken(InteractiveRequestParameters.builder((URI)redirectUri).scopes(this.scopes).loginHint(this.usernameHint).build());
            result = (IAuthenticationResult)future.get(120000L, TimeUnit.MILLISECONDS);
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, "Error acquiring ApplicationAccessToken due to invalid Authority URL", e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        if (result == null) {
            throw new DataServiceException(this.clusterUrl, "acquireWithUserPrompt got 'null' authentication result", false);
        }
        return result;
    }

    @Override
    IAccount getAccount(Set<IAccount> accountSet) {
        if (StringUtils.isNotBlank((CharSequence)this.usernameHint)) {
            return accountSet.stream().filter(u -> this.usernameHint.equalsIgnoreCase(u.username())).findAny().orElse(null);
        }
        if (accountSet.isEmpty()) {
            return null;
        }
        return accountSet.iterator().next();
    }

    @Override
    protected String getAuthMethod() {
        return USER_PROMPT_TOKEN_PROVIDER;
    }

    static {
        URI tmp;
        try {
            tmp = new URI("http://localhost");
        }
        catch (URISyntaxException e) {
            tmp = null;
        }
        redirectUri = tmp;
    }
}

