/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.microsoft.azure.kusto.data.KustoResultColumn;
import com.microsoft.azure.kusto.data.WellKnownDataSet;
import com.microsoft.azure.kusto.data.exceptions.JsonPropertyMissingException;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class KustoResultSetTable {
    protected static final String TABLE_NAME_PROPERTY_NAME = "TableName";
    protected static final String TABLE_ID_PROPERTY_NAME = "TableId";
    protected static final String TABLE_KIND_PROPERTY_NAME = "TableKind";
    protected static final String COLUMNS_PROPERTY_NAME = "Columns";
    protected static final String COLUMN_NAME_PROPERTY_NAME = "ColumnName";
    protected static final String COLUMN_TYPE_PROPERTY_NAME = "ColumnType";
    protected static final String COLUMN_TYPE_SECOND_PROPERTY_NAME = "DataType";
    protected static final String ROWS_PROPERTY_NAME = "Rows";
    protected static final String EXCEPTIONS_PROPERTY_NAME = "Exceptions";
    static final String EXCEPTIONS_MESSAGE = "Query execution failed with multiple inner exceptions";
    private static final String EMPTY_STRING = "";
    private static final DateTimeFormatter kustoDateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendLiteral('Z').toFormatter();
    private final List<List<Object>> rows;
    private String tableName;
    private String tableId;
    private WellKnownDataSet tableKind;
    private final Map<String, KustoResultColumn> columns = new HashMap<String, KustoResultColumn>();
    private KustoResultColumn[] columnsAsArray = null;
    private Iterator<List<Object>> rowIterator;
    private List<Object> currentRow = null;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableId() {
        return this.tableId;
    }

    public WellKnownDataSet getTableKind() {
        return this.tableKind;
    }

    public KustoResultColumn[] getColumns() {
        return this.columnsAsArray;
    }

    void setTableId(String tableId) {
        this.tableId = tableId;
    }

    void setTableKind(WellKnownDataSet tableKind) {
        this.tableKind = tableKind;
    }

    protected KustoResultSetTable(JsonNode jsonTable) throws KustoServiceQueryError, JsonPropertyMissingException {
        ArrayNode columnsJson;
        if (jsonTable.has(TABLE_NAME_PROPERTY_NAME)) {
            this.tableName = jsonTable.get(TABLE_NAME_PROPERTY_NAME).asText();
        }
        if (jsonTable.has(TABLE_ID_PROPERTY_NAME)) {
            this.tableId = jsonTable.get(TABLE_ID_PROPERTY_NAME).asText();
        }
        this.tableId = jsonTable.has(TABLE_ID_PROPERTY_NAME) ? jsonTable.get(TABLE_ID_PROPERTY_NAME).asText() : EMPTY_STRING;
        String tableKindString = jsonTable.has(TABLE_KIND_PROPERTY_NAME) ? jsonTable.get(TABLE_KIND_PROPERTY_NAME).asText() : EMPTY_STRING;
        WellKnownDataSet wellKnownDataSet = this.tableKind = StringUtils.isBlank((CharSequence)tableKindString) ? null : WellKnownDataSet.valueOf(tableKindString);
        if (jsonTable.has(COLUMNS_PROPERTY_NAME) && jsonTable.get(COLUMNS_PROPERTY_NAME).getNodeType() == JsonNodeType.ARRAY && (columnsJson = (ArrayNode)jsonTable.get(COLUMNS_PROPERTY_NAME)) != null) {
            this.columnsAsArray = new KustoResultColumn[columnsJson.size()];
            for (int i = 0; i < columnsJson.size(); ++i) {
                KustoResultColumn col;
                String columnType;
                JsonNode jsonCol = columnsJson.get(i);
                String string = columnType = jsonCol.has(COLUMN_TYPE_PROPERTY_NAME) ? jsonCol.get(COLUMN_TYPE_PROPERTY_NAME).asText() : EMPTY_STRING;
                if (columnType.isEmpty()) {
                    String string2 = columnType = jsonCol.has(COLUMN_TYPE_SECOND_PROPERTY_NAME) ? jsonCol.get(COLUMN_TYPE_SECOND_PROPERTY_NAME).asText() : EMPTY_STRING;
                }
                if (!jsonCol.has(COLUMN_NAME_PROPERTY_NAME)) {
                    throw new JsonPropertyMissingException("Column Name property is missing in the json response");
                }
                this.columnsAsArray[i] = col = new KustoResultColumn(jsonCol.has(COLUMN_NAME_PROPERTY_NAME) ? jsonCol.get(COLUMN_NAME_PROPERTY_NAME).asText() : EMPTY_STRING, columnType, i);
                this.columns.put(jsonCol.has(COLUMN_NAME_PROPERTY_NAME) ? jsonCol.get(COLUMN_NAME_PROPERTY_NAME).asText() : EMPTY_STRING, col);
            }
        }
        ArrayNode jsonRows = null;
        if (jsonTable.has(ROWS_PROPERTY_NAME) && jsonTable.get(ROWS_PROPERTY_NAME).getNodeType() == JsonNodeType.ARRAY) {
            jsonRows = (ArrayNode)jsonTable.get(ROWS_PROPERTY_NAME);
        }
        if (jsonRows != null) {
            ArrayList<List<Object>> values = new ArrayList<List<Object>>();
            for (int i = 0; i < jsonRows.size(); ++i) {
                JsonNode row = jsonRows.get(i);
                if (jsonRows.get(i).getNodeType() == JsonNodeType.OBJECT) {
                    ArrayNode exceptions;
                    ArrayNode arrayNode = exceptions = row.has(EXCEPTIONS_PROPERTY_NAME) ? (ArrayNode)row.get(EXCEPTIONS_PROPERTY_NAME) : null;
                    if (exceptions != null) {
                        if (exceptions.size() == 1) {
                            String message = exceptions.get(0).asText();
                            throw new KustoServiceQueryError(exceptions, true, message);
                        }
                        throw new KustoServiceQueryError(exceptions, false, EXCEPTIONS_MESSAGE);
                    }
                    throw new KustoServiceQueryError((ArrayNode)row.get("OneApiErrors"), true, EXCEPTIONS_MESSAGE);
                }
                ArrayNode rowAsJsonArray = (ArrayNode)jsonRows.get(i);
                ArrayList<Object> rowVector = new ArrayList<Object>();
                block7: for (int j = 0; j < rowAsJsonArray.size(); ++j) {
                    JsonNode obj = rowAsJsonArray.get(j);
                    if (obj.isNull()) {
                        rowVector.add(null);
                        continue;
                    }
                    switch (rowAsJsonArray.get(j).getNodeType()) {
                        case STRING: {
                            rowVector.add(obj.asText());
                            continue block7;
                        }
                        case BOOLEAN: {
                            rowVector.add(obj.asBoolean());
                            continue block7;
                        }
                        case NUMBER: {
                            if (obj.isInt()) {
                                rowVector.add(obj.asInt());
                                continue block7;
                            }
                            if (obj.isLong()) {
                                rowVector.add(obj.asLong());
                                continue block7;
                            }
                            if (obj.isBigDecimal()) {
                                rowVector.add(obj.decimalValue());
                                continue block7;
                            }
                            if (obj.isDouble()) {
                                rowVector.add(obj.asDouble());
                                continue block7;
                            }
                            if (obj.isShort()) {
                                rowVector.add(obj.shortValue());
                                continue block7;
                            }
                            if (obj.isFloat()) {
                                rowVector.add(Float.valueOf(obj.floatValue()));
                                continue block7;
                            }
                            rowVector.add(obj);
                            continue block7;
                        }
                        default: {
                            rowVector.add(obj);
                        }
                    }
                }
                values.add(rowVector);
            }
            this.rows = values;
        } else {
            this.rows = new ArrayList<List<Object>>();
        }
        this.rowIterator = this.rows.iterator();
    }

    public List<Object> getCurrentRow() {
        return this.currentRow;
    }

    public boolean next() {
        boolean hasNext = this.hasNext();
        if (hasNext) {
            this.currentRow = this.rowIterator.next();
        }
        return hasNext;
    }

    public boolean hasNext() {
        return this.rowIterator.hasNext();
    }

    public List<List<Object>> getData() {
        return this.rows;
    }

    private Object get(int columnIndex) {
        return this.currentRow.get(columnIndex);
    }

    private Object get(String columnName) {
        return this.currentRow.get(this.findColumn(columnName));
    }

    public String getString(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public boolean getBoolean(int columnIndex) {
        return (Boolean)this.get(columnIndex);
    }

    public Boolean getBooleanObject(int columnIndex) {
        return (Boolean)this.get(columnIndex);
    }

    public byte getByte(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).byteValue();
        }
        return (Byte)obj;
    }

    private Object getShortGeneric(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).shortValue();
        }
        return obj;
    }

    public short getShort(int columnIndex) {
        return (Short)this.getShortGeneric(columnIndex);
    }

    public Short getShortObject(int columnIndex) {
        return (Short)this.getShortGeneric(columnIndex);
    }

    public int getInt(int columnIndex) {
        return (Integer)this.get(columnIndex);
    }

    public Integer getIntegerObject(int columnIndex) {
        return (Integer)this.get(columnIndex);
    }

    private Object getLongGeneric(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        return obj;
    }

    public long getLong(int columnIndex) {
        return (Long)this.getLongGeneric(columnIndex);
    }

    public Long getLongObject(int columnIndex) {
        return (Long)this.getLongGeneric(columnIndex);
    }

    private Object getFloatGeneric(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)obj).floatValue());
        }
        return obj;
    }

    public float getFloat(int columnIndex) {
        return ((Float)this.getFloatGeneric(columnIndex)).floatValue();
    }

    public Float getFloatObject(int columnIndex) {
        return (Float)this.getFloatGeneric(columnIndex);
    }

    private Object getDoubleGeneric(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return obj;
    }

    public double getDouble(int columnIndex) {
        return (Double)this.getDoubleGeneric(columnIndex);
    }

    public Double getDoubleObject(int columnIndex) {
        return (Double)this.getDoubleGeneric(columnIndex);
    }

    public byte[] getBytes(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        return (byte[])obj;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    public Time getTime(int columnIndex) {
        LocalTime time = this.getLocalTime(columnIndex);
        if (time == null) {
            return null;
        }
        return Time.valueOf(this.getLocalTime(columnIndex));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        switch (this.columnsAsArray[columnIndex].getColumnType()) {
            case "string": 
            case "datetime": {
                if (this.get(columnIndex) == null) {
                    return null;
                }
                return Timestamp.valueOf(StringUtils.chop((String)this.getString(columnIndex)).replace("T", " "));
            }
            case "long": 
            case "int": {
                Long l = this.getLongObject(columnIndex);
                if (l == null) {
                    return null;
                }
                return new Timestamp(l);
            }
        }
        throw new SQLException("Error parsing timestamp - expected string or long columns.");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLFeatureNotSupportedException {
        if (this.columnsAsArray[columnIndex].getColumnType().equals("String")) {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes());
        }
        throw new SQLFeatureNotSupportedException("getBinaryStream is only available for strings");
    }

    public String getString(String columnName) {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Boolean getBooleanObject(String columnName) {
        return this.getBooleanObject(this.findColumn(columnName));
    }

    public byte getByte(String columnName) {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) {
        return this.getShort(this.findColumn(columnName));
    }

    public Short getShortObject(String columnName) {
        return this.getShortObject(this.findColumn(columnName));
    }

    public int getInt(String columnName) {
        return this.getInt(this.findColumn(columnName));
    }

    public Integer getIntegerObject(String columnName) {
        return this.getIntegerObject(this.findColumn(columnName));
    }

    public long getLong(String columnName) {
        return this.getLong(this.findColumn(columnName));
    }

    public Long getLongObject(String columnName) {
        return this.getLongObject(this.findColumn(columnName));
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.findColumn(columnName));
    }

    public Float getFloatObject(String columnName) {
        return this.getFloatObject(this.findColumn(columnName));
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.findColumn(columnName));
    }

    public Double getDoubleObject(String columnName) {
        return this.getDoubleObject(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) {
        return (InputStream)this.get(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLFeatureNotSupportedException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex) {
        return this.get(columnIndex);
    }

    public Object getObject(String columnName) {
        return this.get(columnName);
    }

    public JsonNode getJSONObject(String columnName) {
        return this.getJSONObject(this.findColumn(columnName));
    }

    public JsonNode getJSONObject(int columnIndex) {
        return (JsonNode)this.get(columnIndex);
    }

    public UUID getUUID(int columnIndex) {
        Object u = this.get(columnIndex);
        if (u == null) {
            return null;
        }
        return UUID.fromString((String)u);
    }

    public UUID getUUID(String columnName) {
        return this.getUUID(this.findColumn(columnName));
    }

    public int findColumn(String columnName) {
        return this.columns.get(columnName).getOrdinal();
    }

    public Reader getCharacterStream(int columnIndex) {
        return new StringReader(this.getString(columnIndex));
    }

    public Reader getCharacterStream(String columnName) {
        return new StringReader(this.getString(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj == null) {
            return null;
        }
        return new BigDecimal(obj.toString());
    }

    public BigDecimal getBigDecimal(String columnName) {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() {
        return this.currentRow == null;
    }

    public boolean isAfterLast() {
        return this.currentRow == null && !this.rowIterator.hasNext();
    }

    public boolean isLast() {
        return this.currentRow != null && !this.rowIterator.hasNext();
    }

    public void beforeFirst() {
        this.rowIterator = this.rows.iterator();
    }

    public boolean first() {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.rowIterator = this.rows.iterator();
        this.currentRow = this.rowIterator.next();
        return true;
    }

    public boolean last() {
        if (this.rows.isEmpty()) {
            return false;
        }
        while (this.rowIterator.next() != null) {
        }
        return true;
    }

    public boolean relative(int columnIndex) {
        return false;
    }

    public Array getArray(int columnIndex) {
        return (Array)this.get(columnIndex);
    }

    public Array getArray(String columnName) {
        return this.getArray(this.findColumn(columnName));
    }

    public LocalDateTime getKustoDateTime(int columnIndex) {
        if (this.get(columnIndex) == null) {
            return null;
        }
        String dateString = this.getString(columnIndex);
        return LocalDateTime.parse(dateString, kustoDateTimeFormatter);
    }

    public LocalDateTime getKustoDateTime(String columnName) {
        return this.getKustoDateTime(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(columnIndex);
        }
        switch (this.columnsAsArray[columnIndex].getColumnType()) {
            case "string": 
            case "datetime": {
                try {
                    if (this.get(columnIndex) == null) {
                        return null;
                    }
                    String dateString = this.getString(columnIndex);
                    FastDateFormat dateFormat = dateString.length() < 21 ? FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss", (TimeZone)calendar.getTimeZone()) : FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)calendar.getTimeZone());
                    return new Date(dateFormat.parse(dateString.substring(0, Math.min(dateString.length() - 1, 23))).getTime());
                }
                catch (Exception e) {
                    throw new SQLException("Error parsing Date", e);
                }
            }
            case "long": 
            case "int": {
                Long longVal = this.getLongObject(columnIndex);
                if (longVal == null) {
                    return null;
                }
                return new Date(longVal);
            }
        }
        throw new SQLException("Error parsing Date - expected string, long or datetime data type.");
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(columnName);
    }

    public LocalTime getLocalTime(int columnIndex) {
        Object time = this.get(columnIndex);
        if (time == null) {
            return null;
        }
        return LocalTime.parse((String)time);
    }

    public LocalTime getLocalTime(String columnName) {
        return this.getLocalTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    public URL getURL(String columnName) throws SQLException {
        try {
            return new URL(this.getString(columnName));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    public int count() {
        return this.rows.size();
    }

    public boolean isNull(int columnIndex) {
        return this.get(columnIndex) == null;
    }
}

