/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.config;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SpringCloudClusterConfig {
    private String subscriptionId;
    private String resourceGroup;
    private String clusterName;
    private String region;
    private String sku;
    private String environment;
    private String environmentResourceGroup;

    @Nonnull
    public static SpringCloudClusterConfig fromCluster(@Nonnull SpringCloudCluster cluster) {
        SpringCloudClusterConfig config = new SpringCloudClusterConfig();
        config.setSubscriptionId(cluster.getSubscriptionId());
        config.setResourceGroup(((SpringCloudServiceSubscription)cluster.getParent()).getResourceGroupName());
        config.setRegion(Objects.requireNonNull(cluster.getRegion()).name());
        config.setClusterName(cluster.getName());
        config.setSku(cluster.getSku().toString());
        if (cluster.isConsumptionTier()) {
            ResourceId environment = ResourceId.fromString((String)cluster.getManagedEnvironmentId());
            config.setEnvironment(environment.name());
            config.setEnvironmentResourceGroup(environment.resourceGroupName());
        }
        return config;
    }

    public static SpringCloudClusterConfigBuilder builder() {
        return new SpringCloudClusterConfigBuilder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSku() {
        return this.sku;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getEnvironmentResourceGroup() {
        return this.environmentResourceGroup;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setEnvironmentResourceGroup(String environmentResourceGroup) {
        this.environmentResourceGroup = environmentResourceGroup;
    }

    public SpringCloudClusterConfig() {
    }

    public SpringCloudClusterConfig(String subscriptionId, String resourceGroup, String clusterName, String region, String sku, String environment, String environmentResourceGroup) {
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.clusterName = clusterName;
        this.region = region;
        this.sku = sku;
        this.environment = environment;
        this.environmentResourceGroup = environmentResourceGroup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudClusterConfig)) {
            return false;
        }
        SpringCloudClusterConfig other = (SpringCloudClusterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$resourceGroup = this.getResourceGroup();
        String other$resourceGroup = other.getResourceGroup();
        if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$environmentResourceGroup = this.getEnvironmentResourceGroup();
        String other$environmentResourceGroup = other.getEnvironmentResourceGroup();
        return !(this$environmentResourceGroup == null ? other$environmentResourceGroup != null : !this$environmentResourceGroup.equals(other$environmentResourceGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudClusterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $resourceGroup = this.getResourceGroup();
        result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $environmentResourceGroup = this.getEnvironmentResourceGroup();
        result = result * 59 + ($environmentResourceGroup == null ? 43 : $environmentResourceGroup.hashCode());
        return result;
    }

    public static class SpringCloudClusterConfigBuilder {
        private String subscriptionId;
        private String resourceGroup;
        private String clusterName;
        private String region;
        private String sku;
        private String environment;
        private String environmentResourceGroup;

        SpringCloudClusterConfigBuilder() {
        }

        public SpringCloudClusterConfigBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public SpringCloudClusterConfigBuilder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public SpringCloudClusterConfigBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public SpringCloudClusterConfigBuilder region(String region) {
            this.region = region;
            return this;
        }

        public SpringCloudClusterConfigBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public SpringCloudClusterConfigBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public SpringCloudClusterConfigBuilder environmentResourceGroup(String environmentResourceGroup) {
            this.environmentResourceGroup = environmentResourceGroup;
            return this;
        }

        public SpringCloudClusterConfig build() {
            return new SpringCloudClusterConfig(this.subscriptionId, this.resourceGroup, this.clusterName, this.region, this.sku, this.environment, this.environmentResourceGroup);
        }

        public String toString() {
            return "SpringCloudClusterConfig.SpringCloudClusterConfigBuilder(subscriptionId=" + this.subscriptionId + ", resourceGroup=" + this.resourceGroup + ", clusterName=" + this.clusterName + ", region=" + this.region + ", sku=" + this.sku + ", environment=" + this.environment + ", environmentResourceGroup=" + this.environmentResourceGroup + ")";
        }
    }
}

