/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.config;

import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudClusterConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

public class SpringCloudAppConfig {
    private SpringCloudClusterConfig cluster;
    private String appName;
    private Boolean isPublic;
    @Nullable
    private String activeDeploymentName;
    private SpringCloudDeploymentConfig deployment;

    @Nonnull
    public Boolean isPublic() {
        return BooleanUtils.isTrue((Boolean)this.isPublic);
    }

    public String getSubscriptionId() {
        return Optional.ofNullable(this.cluster).map(SpringCloudClusterConfig::getSubscriptionId).orElse(null);
    }

    public void setSubscriptionId(String subscriptionId) {
        this.ensureCluster().setSubscriptionId(subscriptionId);
    }

    public String getResourceGroup() {
        return Optional.ofNullable(this.cluster).map(SpringCloudClusterConfig::getResourceGroup).orElse(null);
    }

    public void setResourceGroup(String resourceGroup) {
        this.ensureCluster().setResourceGroup(resourceGroup);
    }

    public String getClusterName() {
        return Optional.ofNullable(this.cluster).map(SpringCloudClusterConfig::getClusterName).orElse(null);
    }

    public void setClusterName(String clusterName) {
        this.ensureCluster().setClusterName(clusterName);
    }

    private SpringCloudClusterConfig ensureCluster() {
        this.cluster = Optional.ofNullable(this.cluster).orElseGet(SpringCloudClusterConfig::new);
        return this.cluster;
    }

    @Nonnull
    public static SpringCloudAppConfig fromApp(@Nonnull SpringCloudApp app) {
        SpringCloudDeployment deployment = Optional.ofNullable(app.getActiveDeployment()).orElse((SpringCloudDeployment)app.deployments().getOrDraft("default", app.getResourceGroupName()));
        SpringCloudDeploymentConfig deploymentConfig = SpringCloudDeploymentConfig.fromDeployment(deployment);
        SpringCloudAppConfig appConfig = SpringCloudAppConfig.builder().deployment(deploymentConfig).build();
        appConfig.setCluster(SpringCloudClusterConfig.fromCluster((SpringCloudCluster)app.getParent()));
        appConfig.setAppName(app.getName());
        appConfig.setIsPublic(Objects.equals(app.isPublicEndpointEnabled(), true));
        return appConfig;
    }

    private static Boolean $default$isPublic() {
        return false;
    }

    public static SpringCloudAppConfigBuilder builder() {
        return new SpringCloudAppConfigBuilder();
    }

    public SpringCloudClusterConfig getCluster() {
        return this.cluster;
    }

    public String getAppName() {
        return this.appName;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    @Nullable
    public String getActiveDeploymentName() {
        return this.activeDeploymentName;
    }

    public SpringCloudDeploymentConfig getDeployment() {
        return this.deployment;
    }

    public void setCluster(SpringCloudClusterConfig cluster) {
        this.cluster = cluster;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setActiveDeploymentName(@Nullable String activeDeploymentName) {
        this.activeDeploymentName = activeDeploymentName;
    }

    public void setDeployment(SpringCloudDeploymentConfig deployment) {
        this.deployment = deployment;
    }

    public SpringCloudAppConfig() {
        this.isPublic = SpringCloudAppConfig.$default$isPublic();
    }

    public SpringCloudAppConfig(SpringCloudClusterConfig cluster, String appName, Boolean isPublic, @Nullable String activeDeploymentName, SpringCloudDeploymentConfig deployment) {
        this.cluster = cluster;
        this.appName = appName;
        this.isPublic = isPublic;
        this.activeDeploymentName = activeDeploymentName;
        this.deployment = deployment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudAppConfig)) {
            return false;
        }
        SpringCloudAppConfig other = (SpringCloudAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPublic = this.getIsPublic();
        Boolean other$isPublic = other.getIsPublic();
        if (this$isPublic == null ? other$isPublic != null : !((Object)this$isPublic).equals(other$isPublic)) {
            return false;
        }
        SpringCloudClusterConfig this$cluster = this.getCluster();
        SpringCloudClusterConfig other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$activeDeploymentName = this.getActiveDeploymentName();
        String other$activeDeploymentName = other.getActiveDeploymentName();
        if (this$activeDeploymentName == null ? other$activeDeploymentName != null : !this$activeDeploymentName.equals(other$activeDeploymentName)) {
            return false;
        }
        SpringCloudDeploymentConfig this$deployment = this.getDeployment();
        SpringCloudDeploymentConfig other$deployment = other.getDeployment();
        return !(this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudAppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPublic = this.getIsPublic();
        result = result * 59 + ($isPublic == null ? 43 : ((Object)$isPublic).hashCode());
        SpringCloudClusterConfig $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $activeDeploymentName = this.getActiveDeploymentName();
        result = result * 59 + ($activeDeploymentName == null ? 43 : $activeDeploymentName.hashCode());
        SpringCloudDeploymentConfig $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        return result;
    }

    public static class SpringCloudAppConfigBuilder {
        private SpringCloudClusterConfig cluster;
        private String appName;
        private boolean isPublic$set;
        private Boolean isPublic$value;
        private String activeDeploymentName;
        private SpringCloudDeploymentConfig deployment;

        SpringCloudAppConfigBuilder() {
        }

        public SpringCloudAppConfigBuilder cluster(SpringCloudClusterConfig cluster) {
            this.cluster = cluster;
            return this;
        }

        public SpringCloudAppConfigBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public SpringCloudAppConfigBuilder isPublic(Boolean isPublic) {
            this.isPublic$value = isPublic;
            this.isPublic$set = true;
            return this;
        }

        public SpringCloudAppConfigBuilder activeDeploymentName(@Nullable String activeDeploymentName) {
            this.activeDeploymentName = activeDeploymentName;
            return this;
        }

        public SpringCloudAppConfigBuilder deployment(SpringCloudDeploymentConfig deployment) {
            this.deployment = deployment;
            return this;
        }

        public SpringCloudAppConfig build() {
            Boolean isPublic$value = this.isPublic$value;
            if (!this.isPublic$set) {
                isPublic$value = SpringCloudAppConfig.$default$isPublic();
            }
            return new SpringCloudAppConfig(this.cluster, this.appName, isPublic$value, this.activeDeploymentName, this.deployment);
        }

        public String toString() {
            return "SpringCloudAppConfig.SpringCloudAppConfigBuilder(cluster=" + this.cluster + ", appName=" + this.appName + ", isPublic$value=" + this.isPublic$value + ", activeDeploymentName=" + this.activeDeploymentName + ", deployment=" + this.deployment + ")";
        }
    }
}

