/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployments;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudDeploymentModule
extends AbstractAzResourceModule<SpringCloudDeployment, SpringCloudApp, SpringAppDeployment> {
    public static final String NAME = "deployments";

    public SpringCloudDeploymentModule(@Nonnull SpringCloudApp parent) {
        super(NAME, (AzResource)parent);
    }

    public SpringAppDeployments<?> getClient() {
        return Optional.ofNullable((SpringApp)((SpringCloudApp)this.parent).getRemote()).map(SpringApp::deployments).orElse(null);
    }

    @Nonnull
    protected SpringCloudDeploymentDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudDeploymentDraft(name, this);
    }

    @Nonnull
    protected SpringCloudDeploymentDraft newDraftForUpdate(@Nonnull SpringCloudDeployment origin) {
        return new SpringCloudDeploymentDraft(origin);
    }

    @Nonnull
    protected SpringCloudDeployment newResource(@Nonnull SpringAppDeployment remote) {
        return new SpringCloudDeployment(remote, this);
    }

    @Nonnull
    protected SpringCloudDeployment newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudDeployment(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring App deployment";
    }
}

