/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.AppResourceInner;
import com.azure.resourcemanager.appplatform.models.ActiveDeploymentCollection;
import com.azure.resourcemanager.appplatform.models.AppResourceProperties;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudClusterConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudAppDraft
extends SpringCloudApp
implements AzResource.Draft<SpringCloudApp, SpringApp> {
    private static final String UPDATE_APP_WARNING = "It may take some moments for the configuration to be applied at server side!";
    public static final String DEFAULT_DISK_MOUNT_PATH = "/persistent";
    public static final String DEFAULT_DEPLOYMENT_NAME = "default";
    public static final int BASIC_TIER_DEFAULT_DISK_SIZE = 1;
    public static final int STANDARD_TIER_DEFAULT_DISK_SIZE = 50;
    public static final int DEFAULT_TEMP_DISK_SIZE = 5;
    public static final String DEFAULT_TEMP_DISK_MOUNT_PATH = "/tmp";
    @Nullable
    private final SpringCloudApp origin;
    @Nullable
    private SpringCloudDeployment activeDeployment;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    SpringCloudAppDraft(@Nonnull String name, @Nonnull SpringCloudAppModule module) {
        super(name, module);
        this.origin = null;
    }

    SpringCloudAppDraft(@Nonnull SpringCloudApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void setConfig(@Nonnull SpringCloudAppConfig c) {
        this.setName(c.getAppName());
        this.setActiveDeploymentName(c.getActiveDeploymentName());
        this.setPublicEndpointEnabled(c.getIsPublic());
        SpringCloudDeploymentConfig deploymentConfig = c.getDeployment();
        SpringCloudDeploymentDraft deploymentDraft = this.updateOrCreateActiveDeployment();
        this.setPersistentDiskEnabled(deploymentConfig.getEnablePersistentStorage());
        deploymentDraft.setConfig(deploymentConfig);
    }

    @Nonnull
    public SpringCloudAppConfig getConfig() {
        SpringCloudDeploymentConfig deploymentConfig = this.activeDeployment instanceof SpringCloudDeploymentDraft ? ((SpringCloudDeploymentDraft)this.activeDeployment).getConfig() : SpringCloudDeploymentConfig.builder().build();
        deploymentConfig.setEnablePersistentStorage(this.isPersistentDiskEnabled());
        return SpringCloudAppConfig.builder().cluster(SpringCloudClusterConfig.fromCluster((SpringCloudCluster)this.getParent())).appName(this.getName()).isPublic(this.isPublicEndpointEnabled()).activeDeploymentName(this.getActiveDeploymentName()).deployment(deploymentConfig).build();
    }

    public void reset() {
        this.config = null;
        this.activeDeployment = null;
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.create_app.app", params={"this.getName()"})
    public SpringApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String appName = this.getName();
            SpringService service = Objects.requireNonNull((SpringService)((SpringCloudCluster)this.getParent()).getRemote());
            boolean newPublicEndpointEnabled = this.isPublicEndpointEnabled();
            Integer newDiskSize = this.isPersistentDiskEnabled() ? Integer.valueOf(((SpringCloudCluster)this.getParent()).isStandardTier() ? 50 : 1) : null;
            PersistentDisk newDisk = this.isPersistentDiskEnabled() ? new PersistentDisk().withSizeInGB(newDiskSize).withMountPath(DEFAULT_DISK_MOUNT_PATH) : null;
            TemporaryDisk tmpDisk = ((SpringCloudCluster)this.getParent()).isEnterpriseTier() ? null : new TemporaryDisk().withSizeInGB(Integer.valueOf(5)).withMountPath(DEFAULT_TEMP_DISK_MOUNT_PATH);
            AppResourceInner appResource = new AppResourceInner().withProperties(new AppResourceProperties().withPersistentDisk(newDisk).withTemporaryDisk(tmpDisk).withPublicProperty(Boolean.valueOf(newPublicEndpointEnabled)));
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating app({0})...", (Object[])new Object[]{appName}));
            ((AppPlatformManagementClient)((AppPlatformManager)service.manager()).serviceClient()).getApps().createOrUpdate(this.getResourceGroupName(), service.name(), appName, appResource);
            messager.success(AzureString.format((String)"App({0}) is successfully created.", (Object[])new Object[]{appName}));
            SpringApp springApp = (SpringApp)service.apps().getByName(appName);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.update_app.app", params={"this.getName()"})
    public SpringApp updateResourceInAzure(@Nonnull SpringApp origin) {
        SpringApp springApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)springApp);
        try {
            SpringApp springApp2;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.isModified()) {
                String oldActiveDeploymentName = super.getActiveDeploymentName();
                String newActiveDeploymentName = this.getActiveDeploymentName();
                boolean newPublicEndpointEnabled = this.isPublicEndpointEnabled();
                Integer newDiskSize = this.isPersistentDiskEnabled() ? Integer.valueOf(((SpringCloudCluster)this.getParent()).isStandardTier() ? 50 : 1) : null;
                PersistentDisk newDisk = this.isPersistentDiskEnabled() ? new PersistentDisk().withSizeInGB(newDiskSize).withMountPath(DEFAULT_DISK_MOUNT_PATH) : new PersistentDisk().withSizeInGB(Integer.valueOf(0)).withMountPath(DEFAULT_DISK_MOUNT_PATH);
                AppResourceInner appResource = new AppResourceInner().withProperties(new AppResourceProperties().withPersistentDisk(newDisk).withPublicProperty(Boolean.valueOf(newPublicEndpointEnabled)));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating app({0})...", (Object[])new Object[]{origin.name()}));
                SpringService service = (SpringService)origin.parent();
                if (!Objects.equals(super.isPublicEndpointEnabled(), newPublicEndpointEnabled) || !Objects.equals(super.isPersistentDiskEnabled(), this.isPersistentDiskEnabled())) {
                    ((AppPlatformManagementClient)((AppPlatformManager)service.manager()).serviceClient()).getApps().createOrUpdate(this.getResourceGroupName(), service.name(), origin.name(), appResource);
                }
                if (!Objects.equals(oldActiveDeploymentName, newActiveDeploymentName) && StringUtils.isNotBlank((CharSequence)newActiveDeploymentName)) {
                    ((AppPlatformManagementClient)((AppPlatformManager)service.manager()).serviceClient()).getApps().setActiveDeployments(this.getResourceGroupName(), service.name(), origin.name(), new ActiveDeploymentCollection().withActiveDeploymentNames(Collections.singletonList(newActiveDeploymentName)));
                }
                messager.success(AzureString.format((String)"App({0}) is successfully updated.", (Object[])new Object[]{origin.name()}));
                messager.warning(UPDATE_APP_WARNING);
                springApp2 = (SpringApp)service.apps().getByName(origin.name());
            } else {
                springApp2 = origin;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setName(@Nonnull String name) {
        this.ensureConfig().setName(name);
    }

    @Nonnull
    public String getName() {
        return Optional.ofNullable(this.config).map(Config::getName).orElseGet(() -> super.getName());
    }

    public void setPublicEndpointEnabled(Boolean enabled) {
        this.ensureConfig().setPublicEndpointEnabled(enabled);
    }

    @Override
    public boolean isPublicEndpointEnabled() {
        return Optional.ofNullable(this.config).map(Config::getPublicEndpointEnabled).orElseGet(() -> super.isPublicEndpointEnabled());
    }

    public void setPersistentDiskEnabled(Boolean enabled) {
        this.ensureConfig().setPersistentDiskEnabled(enabled);
    }

    @Override
    public boolean isPersistentDiskEnabled() {
        Boolean enabled = Optional.ofNullable(this.config).map(Config::getPersistentDiskEnabled).orElseGet(() -> super.isPersistentDiskEnabled());
        return enabled != false && !((SpringCloudCluster)this.getParent()).isEnterpriseTier() && !((SpringCloudCluster)this.getParent()).isConsumptionTier();
    }

    public void setActiveDeploymentName(String name) {
        this.ensureConfig().setActiveDeploymentName(name);
    }

    @Override
    @Nullable
    public String getActiveDeploymentName() {
        return Optional.ofNullable(this.config).map(Config::getActiveDeploymentName).orElseGet(() -> super.getActiveDeploymentName());
    }

    @Override
    @Nullable
    public SpringCloudDeployment getActiveDeployment() {
        return Optional.ofNullable(this.activeDeployment).orElseGet(() -> super.getActiveDeployment());
    }

    @Override
    @Nullable
    public SpringCloudDeployment getCachedActiveDeployment() {
        return Optional.ofNullable(this.activeDeployment).orElseGet(() -> super.getCachedActiveDeployment());
    }

    @Nonnull
    public SpringCloudDeploymentDraft updateOrCreateActiveDeployment() {
        SpringCloudDeployment deployment = this.getActiveDeployment();
        SpringCloudDeploymentDraft deploymentDraft = Objects.isNull((Object)deployment) ? (SpringCloudDeploymentDraft)this.deployments().create(Optional.ofNullable(this.getActiveDeploymentName()).orElse(DEFAULT_DEPLOYMENT_NAME), null) : (!deployment.isDraft() ? (SpringCloudDeploymentDraft)deployment.update() : (SpringCloudDeploymentDraft)deployment);
        this.setActiveDeployment(deploymentDraft);
        return deploymentDraft;
    }

    public void setActiveDeployment(SpringCloudDeployment activeDeployment) {
        this.activeDeployment = activeDeployment;
        Optional.ofNullable(activeDeployment).map(AbstractAzResource::getName).ifPresent(this::setActiveDeploymentName);
    }

    public boolean isModified() {
        String oldActiveDeploymentName = super.getActiveDeploymentName();
        String newActiveDeploymentName = this.getActiveDeploymentName();
        boolean newPublicEndpointEnabled = this.isPublicEndpointEnabled();
        boolean newPersistentDiskEnabled = this.isPersistentDiskEnabled();
        return !Objects.equals(oldActiveDeploymentName, newActiveDeploymentName) && StringUtils.isNotBlank((CharSequence)newActiveDeploymentName) || !Objects.equals(super.isPublicEndpointEnabled(), newPublicEndpointEnabled) || !Objects.equals(super.isPersistentDiskEnabled(), newPersistentDiskEnabled);
    }

    @Nullable
    public SpringCloudApp getOrigin() {
        return this.origin;
    }

    static {
        SpringCloudAppDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudAppDraft.java", SpringCloudAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft", "", "", "", "com.azure.resourcemanager.appplatform.models.SpringApp"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft", "com.azure.resourcemanager.appplatform.models.SpringApp", "origin", "", "com.azure.resourcemanager.appplatform.models.SpringApp"), 124);
    }

    private static class Config {
        private String name;
        @Nullable
        private String activeDeploymentName;
        @Nullable
        private Boolean publicEndpointEnabled;
        @Nullable
        private Boolean persistentDiskEnabled;

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getActiveDeploymentName() {
            return this.activeDeploymentName;
        }

        @Nullable
        public Boolean getPublicEndpointEnabled() {
            return this.publicEndpointEnabled;
        }

        @Nullable
        public Boolean getPersistentDiskEnabled() {
            return this.persistentDiskEnabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setActiveDeploymentName(@Nullable String activeDeploymentName) {
            this.activeDeploymentName = activeDeploymentName;
        }

        public void setPublicEndpointEnabled(@Nullable Boolean publicEndpointEnabled) {
            this.publicEndpointEnabled = publicEndpointEnabled;
        }

        public void setPersistentDiskEnabled(@Nullable Boolean persistentDiskEnabled) {
            this.persistentDiskEnabled = persistentDiskEnabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$publicEndpointEnabled = this.getPublicEndpointEnabled();
            Boolean other$publicEndpointEnabled = other.getPublicEndpointEnabled();
            if (this$publicEndpointEnabled == null ? other$publicEndpointEnabled != null : !((Object)this$publicEndpointEnabled).equals(other$publicEndpointEnabled)) {
                return false;
            }
            Boolean this$persistentDiskEnabled = this.getPersistentDiskEnabled();
            Boolean other$persistentDiskEnabled = other.getPersistentDiskEnabled();
            if (this$persistentDiskEnabled == null ? other$persistentDiskEnabled != null : !((Object)this$persistentDiskEnabled).equals(other$persistentDiskEnabled)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$activeDeploymentName = this.getActiveDeploymentName();
            String other$activeDeploymentName = other.getActiveDeploymentName();
            return !(this$activeDeploymentName == null ? other$activeDeploymentName != null : !this$activeDeploymentName.equals(other$activeDeploymentName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $publicEndpointEnabled = this.getPublicEndpointEnabled();
            result = result * 59 + ($publicEndpointEnabled == null ? 43 : ((Object)$publicEndpointEnabled).hashCode());
            Boolean $persistentDiskEnabled = this.getPersistentDiskEnabled();
            result = result * 59 + ($persistentDiskEnabled == null ? 43 : ((Object)$persistentDiskEnabled).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $activeDeploymentName = this.getActiveDeploymentName();
            result = result * 59 + ($activeDeploymentName == null ? 43 : $activeDeploymentName.hashCode());
            return result;
        }

        public String toString() {
            return "SpringCloudAppDraft.Config(name=" + this.getName() + ", activeDeploymentName=" + this.getActiveDeploymentName() + ", publicEndpointEnabled=" + this.getPublicEndpointEnabled() + ", persistentDiskEnabled=" + this.getPersistentDiskEnabled() + ")";
        }
    }
}

