/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.cosmosdb;

import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosDatabaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class CosmosHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosHealthIndicator.class);
    @Value(value="${azure.cosmosdb.database}")
    private String dbName;
    @Value(value="${azure.cosmosdb.uri}")
    private String uri;
    @Autowired
    private CosmosClient cosmosClient;

    public CosmosHealthIndicator(CosmosClient cosmosClient) {
        super("CosmosDB health check failed");
        Assert.notNull((Object)cosmosClient, (String)"CosmosClient must not be null");
        this.cosmosClient = cosmosClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        CosmosDatabaseResponse response = (CosmosDatabaseResponse)this.cosmosClient.getDatabase(this.dbName).read().block();
        if (response != null) {
            LOGGER.info("The health indicator cost {} RUs, cosmos uri: {}, dbName: {}", new Object[]{response.requestCharge(), this.uri, this.dbName});
        }
        if (response == null) {
            builder.down();
        } else {
            builder.up().withDetail("database", (Object)response.database().id());
        }
    }
}

