/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class AADOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final OAuth2AuthorizationRequestResolver defaultResolver;

    public AADOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.addClaims(request, this.defaultResolver.resolve(request));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.addClaims(request, this.defaultResolver.resolve(request, clientRegistrationId));
    }

    private OAuth2AuthorizationRequest addClaims(HttpServletRequest httpServletRequest, OAuth2AuthorizationRequest oAuth2AuthorizationRequest) {
        if (oAuth2AuthorizationRequest == null || httpServletRequest == null) {
            return oAuth2AuthorizationRequest;
        }
        String conditionalAccessPolicyClaims = Optional.of(httpServletRequest).map(HttpServletRequest::getSession).map(httpSession -> {
            String claims = (String)httpSession.getAttribute("CAP_Claims");
            if (claims != null) {
                httpSession.removeAttribute("CAP_Claims");
            }
            return claims;
        }).orElse(null);
        if (conditionalAccessPolicyClaims == null) {
            return oAuth2AuthorizationRequest;
        }
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("claims", conditionalAccessPolicyClaims);
        Optional.of(oAuth2AuthorizationRequest).map(OAuth2AuthorizationRequest::getAdditionalParameters).ifPresent(additionalParameters::putAll);
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)oAuth2AuthorizationRequest).additionalParameters(additionalParameters).build();
    }
}

