/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.b2c;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AADB2CAuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private static final String REQUEST_BASE_URI = "/oauth2/authorization";
    private static final String REGISTRATION_ID_NAME = "registrationId";
    private static final String PARAMETER_X_CLIENT_SKU = "x-client-SKU";
    private static final String AAD_B2C_USER_AGENT = "spring-boot-starter";
    private static final String MATCHER_PATTERN = String.format("%s/{%s}", "/oauth2/authorization", "registrationId");
    private static final AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(MATCHER_PATTERN);
    private final OAuth2AuthorizationRequestResolver defaultResolver;
    private final String passwordResetUserFlow;

    public AADB2CAuthorizationRequestResolver(@NonNull ClientRegistrationRepository repository) {
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.passwordResetUserFlow = null;
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(repository, REQUEST_BASE_URI);
    }

    public AADB2CAuthorizationRequestResolver(@NonNull ClientRegistrationRepository repository, @Nullable String passwordResetUserFlow) {
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.passwordResetUserFlow = passwordResetUserFlow;
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(repository, REQUEST_BASE_URI);
    }

    public OAuth2AuthorizationRequest resolve(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.resolve(request, this.getRegistrationId(request));
    }

    public OAuth2AuthorizationRequest resolve(@NonNull HttpServletRequest request, String registrationId) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (StringUtils.hasText((String)this.passwordResetUserFlow) && this.isForgotPasswordAuthorizationRequest(request)) {
            OAuth2AuthorizationRequest authRequest = this.defaultResolver.resolve(request, this.passwordResetUserFlow);
            return this.getB2CAuthorizationRequest(authRequest, this.passwordResetUserFlow);
        }
        if (StringUtils.hasText((String)registrationId) && requestMatcher.matches(request)) {
            return this.getB2CAuthorizationRequest(this.defaultResolver.resolve(request), registrationId);
        }
        return null;
    }

    private void cleanupSecurityContextAuthentication() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private OAuth2AuthorizationRequest getB2CAuthorizationRequest(@Nullable OAuth2AuthorizationRequest request, String userFlow) {
        Assert.hasText((String)userFlow, (String)"User flow should contain text.");
        if (request == null) {
            return null;
        }
        this.cleanupSecurityContextAuthentication();
        HashMap<String, String> parameters = new HashMap<String, String>(request.getAdditionalParameters());
        parameters.put("p", userFlow);
        parameters.put(PARAMETER_X_CLIENT_SKU, AAD_B2C_USER_AGENT);
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)request).additionalParameters(parameters).build();
    }

    private String getRegistrationId(HttpServletRequest request) {
        if (requestMatcher.matches(request)) {
            return (String)requestMatcher.extractUriTemplateVariables(request).get(REGISTRATION_ID_NAME);
        }
        return null;
    }

    private boolean isForgotPasswordAuthorizationRequest(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String error = request.getParameter("error");
        String description = request.getParameter("error_description");
        if ("access_denied".equals(error)) {
            Assert.hasText((String)description, (String)"description should contain text.");
            return description.startsWith("AADB2C90118:");
        }
        return false;
    }
}

