/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.activedirectory")
public class AADAuthenticationProperties {
    private static final Logger log = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private static final String DEFAULT_SERVICE_ENVIRONMENT = "global";
    private UserGroupProperties userGroup = new UserGroupProperties();
    private String environment = "global";
    private String clientId;
    private String clientSecret;
    private List<String> activeDirectoryGroups = new ArrayList<String>();
    private String appIdUri;
    private int jwtConnectTimeout = 500;
    private int jwtReadTimeout = 500;
    private int jwtSizeLimit = 51200;
    private String tenantId;
    private boolean allowTelemetry = true;
    private Boolean sessionStateless = false;

    @DeprecatedConfigurationProperty(reason="Configuration moved to UserGroup class to keep UserGroup properties together", replacement="azure.activedirectory.user-group.allowed-groups")
    public List<String> getActiveDirectoryGroups() {
        return this.activeDirectoryGroups;
    }

    @PostConstruct
    public void validateUserGroupProperties() {
        if (this.sessionStateless.booleanValue()) {
            if (!this.activeDirectoryGroups.isEmpty()) {
                log.warn("Group names are not supported if you set 'sessionSateless' to 'true'.");
            }
        } else if (this.activeDirectoryGroups.isEmpty() && this.getUserGroup().getAllowedGroups().isEmpty()) {
            throw new IllegalStateException("One of the User Group Properties must be populated. Please populate azure.activedirectory.user-group.allowed-groups");
        }
    }

    public UserGroupProperties getUserGroup() {
        return this.userGroup;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public int getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public int getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public Boolean getSessionStateless() {
        return this.sessionStateless;
    }

    public void setUserGroup(UserGroupProperties userGroup) {
        this.userGroup = userGroup;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setActiveDirectoryGroups(List<String> activeDirectoryGroups) {
        this.activeDirectoryGroups = activeDirectoryGroups;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public void setJwtConnectTimeout(int jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public void setJwtReadTimeout(int jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public void setSessionStateless(Boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AADAuthenticationProperties)) {
            return false;
        }
        AADAuthenticationProperties other = (AADAuthenticationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserGroupProperties this$userGroup = this.getUserGroup();
        UserGroupProperties other$userGroup = other.getUserGroup();
        if (this$userGroup == null ? other$userGroup != null : !((Object)this$userGroup).equals(other$userGroup)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        List<String> this$activeDirectoryGroups = this.getActiveDirectoryGroups();
        List<String> other$activeDirectoryGroups = other.getActiveDirectoryGroups();
        if (this$activeDirectoryGroups == null ? other$activeDirectoryGroups != null : !((Object)this$activeDirectoryGroups).equals(other$activeDirectoryGroups)) {
            return false;
        }
        String this$appIdUri = this.getAppIdUri();
        String other$appIdUri = other.getAppIdUri();
        if (this$appIdUri == null ? other$appIdUri != null : !this$appIdUri.equals(other$appIdUri)) {
            return false;
        }
        if (this.getJwtConnectTimeout() != other.getJwtConnectTimeout()) {
            return false;
        }
        if (this.getJwtReadTimeout() != other.getJwtReadTimeout()) {
            return false;
        }
        if (this.getJwtSizeLimit() != other.getJwtSizeLimit()) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        if (this.isAllowTelemetry() != other.isAllowTelemetry()) {
            return false;
        }
        Boolean this$sessionStateless = this.getSessionStateless();
        Boolean other$sessionStateless = other.getSessionStateless();
        return !(this$sessionStateless == null ? other$sessionStateless != null : !((Object)this$sessionStateless).equals(other$sessionStateless));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AADAuthenticationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserGroupProperties $userGroup = this.getUserGroup();
        result = result * 59 + ($userGroup == null ? 43 : ((Object)$userGroup).hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        List<String> $activeDirectoryGroups = this.getActiveDirectoryGroups();
        result = result * 59 + ($activeDirectoryGroups == null ? 43 : ((Object)$activeDirectoryGroups).hashCode());
        String $appIdUri = this.getAppIdUri();
        result = result * 59 + ($appIdUri == null ? 43 : $appIdUri.hashCode());
        result = result * 59 + this.getJwtConnectTimeout();
        result = result * 59 + this.getJwtReadTimeout();
        result = result * 59 + this.getJwtSizeLimit();
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        result = result * 59 + (this.isAllowTelemetry() ? 79 : 97);
        Boolean $sessionStateless = this.getSessionStateless();
        result = result * 59 + ($sessionStateless == null ? 43 : ((Object)$sessionStateless).hashCode());
        return result;
    }

    public String toString() {
        return "AADAuthenticationProperties(userGroup=" + this.getUserGroup() + ", environment=" + this.getEnvironment() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", activeDirectoryGroups=" + this.getActiveDirectoryGroups() + ", appIdUri=" + this.getAppIdUri() + ", jwtConnectTimeout=" + this.getJwtConnectTimeout() + ", jwtReadTimeout=" + this.getJwtReadTimeout() + ", jwtSizeLimit=" + this.getJwtSizeLimit() + ", tenantId=" + this.getTenantId() + ", allowTelemetry=" + this.isAllowTelemetry() + ", sessionStateless=" + this.getSessionStateless() + ")";
    }

    public static class UserGroupProperties {
        private List<String> allowedGroups = new ArrayList<String>();
        @NotEmpty
        private String key = "objectType";
        @NotEmpty
        private String value = "Group";
        @NotEmpty
        private String objectIDKey = "objectId";

        public List<String> getAllowedGroups() {
            return this.allowedGroups;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getObjectIDKey() {
            return this.objectIDKey;
        }

        public void setAllowedGroups(List<String> allowedGroups) {
            this.allowedGroups = allowedGroups;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setObjectIDKey(String objectIDKey) {
            this.objectIDKey = objectIDKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserGroupProperties)) {
                return false;
            }
            UserGroupProperties other = (UserGroupProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedGroups = this.getAllowedGroups();
            List<String> other$allowedGroups = other.getAllowedGroups();
            if (this$allowedGroups == null ? other$allowedGroups != null : !((Object)this$allowedGroups).equals(other$allowedGroups)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$objectIDKey = this.getObjectIDKey();
            String other$objectIDKey = other.getObjectIDKey();
            return !(this$objectIDKey == null ? other$objectIDKey != null : !this$objectIDKey.equals(other$objectIDKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserGroupProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedGroups = this.getAllowedGroups();
            result = result * 59 + ($allowedGroups == null ? 43 : ((Object)$allowedGroups).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $objectIDKey = this.getObjectIDKey();
            result = result * 59 + ($objectIDKey == null ? 43 : $objectIDKey.hashCode());
            return result;
        }

        public String toString() {
            return "AADAuthenticationProperties.UserGroupProperties(allowedGroups=" + this.getAllowedGroups() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", objectIDKey=" + this.getObjectIDKey() + ")";
        }
    }
}

