/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.keyvault.spring.KeyVaultEnvironmentPostProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultEnvironmentPostProcessor.class);
    public static final int DEFAULT_ORDER = -2147483637;
    private int order = -2147483637;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isKeyVaultEnabled(environment)) {
            KeyVaultEnvironmentPostProcessorHelper helper = new KeyVaultEnvironmentPostProcessorHelper(environment);
            helper.addKeyVaultPropertySource();
        }
    }

    private boolean isKeyVaultEnabled(ConfigurableEnvironment environment) {
        if (environment.getProperty("azure.keyvault.uri") == null) {
            return false;
        }
        return (Boolean)environment.getProperty("azure.keyvault.enabled", Boolean.class, (Object)true) != false && this.isKeyVaultClientAvailable();
    }

    private boolean isKeyVaultClientAvailable() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.secrets.SecretClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

