/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring.certificate;

import com.microsoft.azure.keyvault.spring.certificate.KeyCertReader;
import com.microsoft.azure.keyvault.spring.certificate.PfxCertReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FilenameUtils;

public class KeyCertReaderFactory {
    private static final ConcurrentMap<String, KeyCertReader> readerMap = new ConcurrentHashMap<String, KeyCertReader>();
    private static final String NOT_SUPPORTED_CERT = "Certificate type %s not supported.";
    private static final String PFX_EXTENSION = "pfx";

    public static KeyCertReader getReader(String certFile) {
        String extension;
        switch (extension = FilenameUtils.getExtension((String)certFile)) {
            case "pfx": {
                return readerMap.computeIfAbsent(PFX_EXTENSION, k -> new PfxCertReader());
            }
        }
        throw new IllegalStateException(String.format(NOT_SUPPORTED_CERT, extension));
    }
}

