/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import com.microsoft.azure.keyvault.spring.certificate.KeyCert;
import com.microsoft.azure.keyvault.spring.certificate.KeyCertReader;
import com.microsoft.azure.keyvault.spring.certificate.KeyCertReaderFactory;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class KeyVaultCertificateCredential
extends KeyVaultCredentials {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultCertificateCredential.class);
    private static final long DEFAULT_TOKEN_ACQUIRE_TIMEOUT_IN_SECONDS = 60L;
    private final String clientId;
    private final Resource certResource;
    private final String certPassword;
    private final long timeoutInSeconds;

    public KeyVaultCertificateCredential(String clientId, Resource certResource, String certPassword, long timeoutInSeconds) {
        Assert.isTrue((boolean)certResource.exists(), (String)String.format("Certificate file %s should exist.", certResource.getFilename()));
        this.clientId = clientId;
        this.certResource = certResource;
        this.certPassword = certPassword;
        this.timeoutInSeconds = timeoutInSeconds <= 0L ? 60L : timeoutInSeconds;
    }

    public KeyVaultCertificateCredential(String clientId, Resource certResource, String certPassword) {
        this(clientId, certResource, certPassword, 60L);
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        String certFileName = this.certResource.getFilename();
        KeyCertReader certReader = KeyCertReaderFactory.getReader(certFileName);
        KeyCert keyCert = certReader.read(this.certResource, this.certPassword);
        try {
            AuthenticationContext context = new AuthenticationContext(authorization, false, Executors.newSingleThreadExecutor());
            AsymmetricKeyCredential asymmetricKeyCredential = AsymmetricKeyCredential.create((String)this.clientId, (PrivateKey)keyCert.getKey(), (X509Certificate)keyCert.getCertificate());
            AuthenticationResult authResult = (AuthenticationResult)context.acquireToken(resource, asymmetricKeyCredential, null).get(this.timeoutInSeconds, TimeUnit.SECONDS);
            return authResult.getAccessToken();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException | TimeoutException e) {
            String errMsg = String.format("Failed to authenticate with Key Vault using certificate %s", certFileName);
            log.error(errMsg, (Throwable)e);
            throw new IllegalStateException(errMsg, e);
        }
    }
}

