/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import com.microsoft.azure.utils.AADAuthUtil;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;

public class AzureKeyVaultCredential
extends KeyVaultCredentials {
    private static final long DEFAULT_TOKEN_ACQUIRE_TIMEOUT_IN_SECONDS = 60L;
    private String clientId;
    private String clientKey;
    private long timeoutInSeconds;
    private AADAuthUtil aadAuthUtil;
    private String token = "";
    private AtomicLong lastAcquireTokenTime = new AtomicLong();
    private AtomicLong expireIn = new AtomicLong();
    private static final long EXPIRE_BUFFER_TIME = 10000L;

    public AzureKeyVaultCredential(String clientId, String clientKey, long timeoutInSeconds, AADAuthUtil aadAuthUtil) {
        this.clientId = clientId;
        this.clientKey = clientKey;
        this.timeoutInSeconds = timeoutInSeconds;
        this.aadAuthUtil = aadAuthUtil;
    }

    public AzureKeyVaultCredential(String clientId, String clientKey, long timeoutInSeconds) {
        this(clientId, clientKey, timeoutInSeconds, new AADAuthUtil());
    }

    public AzureKeyVaultCredential(String clientId, String clientKey) {
        this(clientId, clientKey, 60L);
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        if (StringUtils.isEmpty((CharSequence)this.token) || this.needRefresh()) {
            this.refreshToken(authorization, resource);
        }
        return this.token;
    }

    private synchronized void refreshToken(String authorization, String resource) {
        if (!this.needRefresh()) {
            return;
        }
        try {
            AuthenticationResult result = this.aadAuthUtil.getToken(authorization, resource, this.clientId, this.clientKey, this.timeoutInSeconds);
            this.token = result.getAccessToken();
            this.expireIn.set(result.getExpiresAfter());
            this.lastAcquireTokenTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to do authentication.", ex);
        }
    }

    private boolean needRefresh() {
        return (System.currentTimeMillis() - this.lastAcquireTokenTime.get() + 10000L) / 1000L >= this.expireIn.get();
    }
}

