/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.RestorePoint;
import com.microsoft.azure.management.sql.SampleName;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlElasticPoolOperations;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolImpl;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.Objects;
import org.joda.time.DateTime;

@LangDefinition
public class SqlDatabaseForElasticPoolImpl
implements SqlDatabase.DefinitionStages.WithExistingDatabaseAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithStorageKeyAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithAuthenticationAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithCreateMode<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithAttachAfterElasticPoolOptions<SqlElasticPoolOperations.DefinitionStages.WithCreate> {
    private SqlDatabaseImpl sqlDatabase;
    private SqlElasticPoolImpl sqlElasticPool;

    SqlDatabaseForElasticPoolImpl(SqlElasticPoolImpl sqlElasticPool, SqlDatabaseImpl sqlDatabase) {
        Objects.requireNonNull(sqlElasticPool);
        Objects.requireNonNull(sqlDatabase);
        Objects.requireNonNull(sqlDatabase.inner());
        this.sqlElasticPool = sqlElasticPool;
        this.sqlDatabase = sqlDatabase;
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withLocation(sqlElasticPool.regionName());
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withElasticPoolName(this.sqlElasticPool.name());
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withEdition(null);
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withRequestedServiceObjectiveName(null);
    }

    public SqlElasticPoolImpl attach() {
        return this.sqlElasticPool;
    }

    public SqlDatabaseForElasticPoolImpl withSourceDatabase(String sourceDatabaseId) {
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSourceDatabase(SqlDatabase sourceDatabase) {
        ((DatabaseInner)((Object)this.sqlDatabase.inner())).withSourceDatabaseId(sourceDatabase.databaseId());
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withMode(CreateMode createMode) {
        this.sqlDatabase.withMode(createMode);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withCollation(String collation) {
        this.sqlDatabase.withCollation(collation);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withMaxSizeBytes(long maxSizeBytes) {
        this.sqlDatabase.withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl importFrom(String storageUri) {
        this.sqlDatabase.importFrom(storageUri);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl importFrom(StorageAccount storageAccount, String containerName, String fileName) {
        this.sqlDatabase.importFrom(storageAccount, containerName, fileName);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withStorageAccessKey(String storageAccessKey) {
        this.sqlDatabase.withStorageAccessKey(storageAccessKey);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSharedAccessKey(String sharedAccessKey) {
        this.sqlDatabase.withSharedAccessKey(sharedAccessKey);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.sqlDatabase.withSqlAdministratorLoginAndPassword(administratorLogin, administratorPassword);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.sqlDatabase.withActiveDirectoryLoginAndPassword(administratorLogin, administratorPassword);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromRestorePoint(RestorePoint restorePoint) {
        this.sqlDatabase.fromRestorePoint(restorePoint);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromRestorePoint(RestorePoint restorePoint, DateTime restorePointDateTime) {
        this.sqlDatabase.fromRestorePoint(restorePoint, restorePointDateTime);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromSample(SampleName sampleName) {
        this.sqlDatabase.fromSample(sampleName);
        return this;
    }
}

