/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.microsoft.azure.management.sql.VulnerabilityAssessmentPolicyBaselineName;
import com.microsoft.azure.management.sql.implementation.DatabaseVulnerabilityAssessmentRuleBaselineInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner {
    private ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService service;
    private SqlManagementClientImpl client;

    public ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService)retrofit.create(ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService.class);
        this.client = client;
    }

    public DatabaseVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, ServiceCallback<DatabaseVulnerabilityAssessmentRuleBaselineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>, DatabaseVulnerabilityAssessmentRuleBaselineInner>(){

            public DatabaseVulnerabilityAssessmentRuleBaselineInner call(ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> response) {
                return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, databaseName, "default", ruleId, baselineName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentRuleBaselineInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName, baselineResults).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults, ServiceCallback<DatabaseVulnerabilityAssessmentRuleBaselineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName, baselineResults), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName, baselineResults).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>, DatabaseVulnerabilityAssessmentRuleBaselineInner>(){

            public DatabaseVulnerabilityAssessmentRuleBaselineInner call(ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> response) {
                return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (baselineResults == null) {
            throw new IllegalArgumentException("Parameter baselineResults is required and cannot be null.");
        }
        Validator.validate(baselineResults);
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters = new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        return this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", ruleId, baselineName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentRuleBaselineInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, ruleId, baselineName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (ruleId == null) {
            throw new IllegalArgumentException("Parameter ruleId is required and cannot be null.");
        }
        if (baselineName == null) {
            throw new IllegalArgumentException("Parameter baselineName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.delete(resourceGroupName, managedInstanceName, databaseName, "default", ruleId, baselineName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselines get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="ruleId") String var5, @Path(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselines createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="ruleId") String var5, @Path(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Body DatabaseVulnerabilityAssessmentRuleBaselineInner var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselines delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="ruleId") String var5, @Path(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);
    }
}

