/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.ServerDnsAliasAcquisition;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.ServerDnsAliasInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServerDnsAliasesInner {
    private ServerDnsAliasesService service;
    private SqlManagementClientImpl client;

    public ServerDnsAliasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerDnsAliasesService)retrofit.create(ServerDnsAliasesService.class);
        this.client = client;
    }

    public ServerDnsAliasInner get(String resourceGroupName, String serverName, String dnsAliasName) {
        return (ServerDnsAliasInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerDnsAliasInner> getAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<ServerDnsAliasInner> getAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>(){

            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return (ServerDnsAliasInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerDnsAliasInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerDnsAliasInner>>>(){

            public Observable<ServiceResponse<ServerDnsAliasInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerDnsAliasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerDnsAliasInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerDnsAliasInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerDnsAliasInner createOrUpdate(String resourceGroupName, String serverName, String dnsAliasName) {
        return (ServerDnsAliasInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last()).body());
    }

    public ServiceFuture<ServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<ServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>(){

            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return (ServerDnsAliasInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerDnsAliasInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerDnsAliasInner>(){}.getType());
    }

    public ServerDnsAliasInner beginCreateOrUpdate(String resourceGroupName, String serverName, String dnsAliasName) {
        return (ServerDnsAliasInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<ServerDnsAliasInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<ServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<ServerDnsAliasInner>, ServerDnsAliasInner>(){

            public ServerDnsAliasInner call(ServiceResponse<ServerDnsAliasInner> response) {
                return (ServerDnsAliasInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerDnsAliasInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerDnsAliasInner>>>(){

            public Observable<ServiceResponse<ServerDnsAliasInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerDnsAliasesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerDnsAliasInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerDnsAliasInner>(){}.getType()).register(201, new TypeToken<ServerDnsAliasInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String dnsAliasName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String dnsAliasName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerDnsAliasesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerDnsAliasInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerDnsAliasInner>((Page)response.body()){

            public Page<ServerDnsAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerDnsAliasesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerDnsAliasInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<ServerDnsAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(String nextPageLink) {
                return ServerDnsAliasesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerDnsAliasInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Page<ServerDnsAliasInner>>(){

            public Page<ServerDnsAliasInner> call(ServiceResponse<Page<ServerDnsAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(ServiceResponse<Page<ServerDnsAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerDnsAliasesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerDnsAliasesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerDnsAliasInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerDnsAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void acquire(String resourceGroupName, String serverName, String dnsAliasName) {
        ((ServiceResponse)this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> acquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Object oldServerDnsAliasId = null;
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(null);
        Observable<Response<ResponseBody>> observable = this.service.acquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void acquire(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        ((ServiceResponse)this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId), serviceCallback);
    }

    public Observable<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        return this.acquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> acquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(oldServerDnsAliasId);
        Observable<Response<ResponseBody>> observable = this.service.acquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginAcquire(String resourceGroupName, String serverName, String dnsAliasName) {
        ((ServiceResponse)this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName), serviceCallback);
    }

    public Observable<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        return this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginAcquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Object oldServerDnsAliasId = null;
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(null);
        return this.service.beginAcquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerDnsAliasesInner.this.beginAcquireDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void beginAcquire(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        ((ServiceResponse)this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId), serviceCallback);
    }

    public Observable<Void> beginAcquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        return this.beginAcquireWithServiceResponseAsync(resourceGroupName, serverName, dnsAliasName, oldServerDnsAliasId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginAcquireWithServiceResponseAsync(String resourceGroupName, String serverName, String dnsAliasName, String oldServerDnsAliasId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (dnsAliasName == null) {
            throw new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        ServerDnsAliasAcquisition parameters = new ServerDnsAliasAcquisition();
        parameters.withOldServerDnsAliasId(oldServerDnsAliasId);
        return this.service.beginAcquire(resourceGroupName, serverName, dnsAliasName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerDnsAliasesInner.this.beginAcquireDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginAcquireDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerDnsAliasInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerDnsAliasInner>((Page)response.body()){

            public Page<ServerDnsAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerDnsAliasesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerDnsAliasInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<ServerDnsAliasInner>> serviceFuture, ListOperationCallback<ServerDnsAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(String nextPageLink) {
                return ServerDnsAliasesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerDnsAliasInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Page<ServerDnsAliasInner>>(){

            public Page<ServerDnsAliasInner> call(ServiceResponse<Page<ServerDnsAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServerDnsAliasInner>>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(ServiceResponse<Page<ServerDnsAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerDnsAliasesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerDnsAliasInner>>>>(){

            public Observable<ServiceResponse<Page<ServerDnsAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerDnsAliasesInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerDnsAliasInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerDnsAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerDnsAliasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases acquire"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}/acquire")
        public Observable<Response<ResponseBody>> acquire(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ServerDnsAliasAcquisition var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases beginAcquire"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}/acquire")
        public Observable<Response<ResponseBody>> beginAcquire(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="dnsAliasName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ServerDnsAliasAcquisition var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerDnsAliases listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

