/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.RecoverableManagedDatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RecoverableManagedDatabasesInner {
    private RecoverableManagedDatabasesService service;
    private SqlManagementClientImpl client;

    public RecoverableManagedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (RecoverableManagedDatabasesService)retrofit.create(RecoverableManagedDatabasesService.class);
        this.client = client;
    }

    public PagedList<RecoverableManagedDatabaseInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<RecoverableManagedDatabaseInner>((Page)response.body()){

            public Page<RecoverableManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecoverableManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecoverableManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(String nextPageLink) {
                return RecoverableManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecoverableManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Page<RecoverableManagedDatabaseInner>>(){

            public Page<RecoverableManagedDatabaseInner> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecoverableManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecoverableManagedDatabasesInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RecoverableManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecoverableManagedDatabaseInner get(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        return (RecoverableManagedDatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName).toBlocking().single()).body());
    }

    public ServiceFuture<RecoverableManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName, ServiceCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName), serviceCallback);
    }

    public Observable<RecoverableManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, recoverableDatabaseName).map((Func1)new Func1<ServiceResponse<RecoverableManagedDatabaseInner>, RecoverableManagedDatabaseInner>(){

            public RecoverableManagedDatabaseInner call(ServiceResponse<RecoverableManagedDatabaseInner> response) {
                return (RecoverableManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RecoverableManagedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String recoverableDatabaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (recoverableDatabaseName == null) {
            throw new IllegalArgumentException("Parameter recoverableDatabaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, recoverableDatabaseName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecoverableManagedDatabaseInner>>>(){

            public Observable<ServiceResponse<RecoverableManagedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecoverableManagedDatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecoverableManagedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecoverableManagedDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecoverableManagedDatabaseInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecoverableManagedDatabaseInner>((Page)response.body()){

            public Page<RecoverableManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecoverableManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecoverableManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<RecoverableManagedDatabaseInner>> serviceFuture, ListOperationCallback<RecoverableManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(String nextPageLink) {
                return RecoverableManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecoverableManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Page<RecoverableManagedDatabaseInner>>(){

            public Page<RecoverableManagedDatabaseInner> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecoverableManagedDatabaseInner>>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(ServiceResponse<Page<RecoverableManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecoverableManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<RecoverableManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecoverableManagedDatabasesInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RecoverableManagedDatabaseInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RecoverableManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RecoverableManagedDatabasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/recoverableDatabases")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/recoverableDatabases/{recoverableDatabaseName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="recoverableDatabaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RecoverableManagedDatabases listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

