/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.ElasticPoolActivity;
import com.microsoft.azure.management.sql.ElasticPoolDatabaseActivity;
import com.microsoft.azure.management.sql.ElasticPoolEdition;
import com.microsoft.azure.management.sql.ElasticPoolState;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseMetric;
import com.microsoft.azure.management.sql.SqlDatabaseMetricDefinition;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumSorage;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardStorage;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.ElasticPoolInner;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_7_0)
public interface SqlElasticPool
extends ExternalChildResource<SqlElasticPool, SqlServer>,
HasInner<ElasticPoolInner>,
HasResourceGroup,
Refreshable<SqlElasticPool>,
Updatable<Update> {
    public String sqlServerName();

    public DateTime creationDate();

    public ElasticPoolState state();

    public ElasticPoolEdition edition();

    public int dtu();

    public int databaseDtuMax();

    public int databaseDtuMin();

    @Deprecated
    public int storageMB();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public int storageCapacityInMB();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public String parentId();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public String regionName();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Region region();

    @Method
    public List<ElasticPoolActivity> listActivities();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    @Method
    public Observable<ElasticPoolActivity> listActivitiesAsync();

    @Method
    public List<ElasticPoolDatabaseActivity> listDatabaseActivities();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    @Method
    public Observable<ElasticPoolDatabaseActivity> listDatabaseActivitiesAsync();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public List<SqlDatabaseMetric> listDatabaseMetrics(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<SqlDatabaseMetric> listDatabaseMetricsAsync(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public List<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitions();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitionsAsync();

    @Method
    public List<SqlDatabase> listDatabases();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<SqlDatabase> listDatabasesAsync();

    public SqlDatabase getDatabase(String var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabase addNewDatabase(String var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabase addExistingDatabase(String var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabase addExistingDatabase(SqlDatabase var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabase removeDatabase(String var1);

    @Method
    public void delete();

    @Method
    public Completable deleteAsync();

    public static interface UpdateStages {

        public static interface WithDatabase {
            public Update withNewDatabase(String var1);

            public Update withExistingDatabase(String var1);

            public Update withExistingDatabase(SqlDatabase var1);
        }

        public static interface WithReservedDTUAndStorageCapacity {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withReservedDtu(SqlElasticPoolBasicEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withReservedDtu(SqlElasticPoolStandardEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withStorageCapacity(SqlElasticPoolStandardStorage var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withReservedDtu(SqlElasticPoolPremiumEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withStorageCapacity(SqlElasticPoolPremiumSorage var1);
        }

        public static interface WithStorageCapacity {
            @Deprecated
            public Update withStorageCapacity(int var1);
        }

        public static interface WithDtu {
            @Deprecated
            public Update withDtu(int var1);
        }

        public static interface WithDatabaseDtuMax {
            @Deprecated
            public Update withDatabaseDtuMax(int var1);
        }

        public static interface WithDatabaseDtuMin {
            @Deprecated
            public Update withDatabaseDtuMin(int var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithReservedDTUAndStorageCapacity,
    UpdateStages.WithDatabaseDtuMax,
    UpdateStages.WithDatabaseDtuMin,
    UpdateStages.WithDtu,
    UpdateStages.WithStorageCapacity,
    UpdateStages.WithDatabase,
    Resource.UpdateWithTags<Update>,
    Appliable<SqlElasticPool> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends WithDatabaseDtuMin<ParentT>,
        WithDatabaseDtuMax<ParentT>,
        WithDtu<ParentT>,
        WithStorageCapacity<ParentT>,
        Attachable.InDefinition<ParentT> {
        }

        public static interface WithStorageCapacity<ParentT> {
            @Deprecated
            public WithAttach<ParentT> withStorageCapacity(int var1);
        }

        public static interface WithDtu<ParentT> {
            @Deprecated
            public WithAttach<ParentT> withDtu(int var1);
        }

        public static interface WithDatabaseDtuMax<ParentT> {
            @Deprecated
            public WithAttach<ParentT> withDatabaseDtuMax(int var1);
        }

        public static interface WithDatabaseDtuMin<ParentT> {
            @Deprecated
            public WithAttach<ParentT> withDatabaseDtuMin(int var1);
        }

        public static interface WithPremiumEdition<ParentT>
        extends WithAttach<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithPremiumEdition<ParentT> withReservedDtu(SqlElasticPoolPremiumEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithPremiumEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithPremiumEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithPremiumEdition<ParentT> withStorageCapacity(SqlElasticPoolPremiumSorage var1);
        }

        public static interface WithStandardEdition<ParentT>
        extends WithAttach<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStandardEdition<ParentT> withReservedDtu(SqlElasticPoolStandardEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStandardEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStandardEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStandardEdition<ParentT> withStorageCapacity(SqlElasticPoolStandardStorage var1);
        }

        public static interface WithBasicEdition<ParentT>
        extends WithAttach<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithBasicEdition<ParentT> withReservedDtu(SqlElasticPoolBasicEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithBasicEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithBasicEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs var1);
        }

        public static interface WithEdition<ParentT> {
            @Deprecated
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttach<ParentT> withEdition(ElasticPoolEdition var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            @Method
            public WithBasicEdition<ParentT> withBasicPool();

            @Beta(value=Beta.SinceVersion.V1_7_0)
            @Method
            public WithStandardEdition<ParentT> withStandardPool();

            @Beta(value=Beta.SinceVersion.V1_7_0)
            @Method
            public WithPremiumEdition<ParentT> withPremiumPool();
        }

        public static interface Blank<ParentT>
        extends WithEdition<ParentT> {
        }
    }

    public static interface SqlElasticPoolDefinition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithEdition<ParentT>,
    DefinitionStages.WithBasicEdition<ParentT>,
    DefinitionStages.WithStandardEdition<ParentT>,
    DefinitionStages.WithPremiumEdition<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }
}

