/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import java.util.List;
import com.microsoft.azure.management.sql.JobTarget;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A group of job targets.
 */
@JsonFlatten
public class JobTargetGroupInner extends ProxyResource {
    /**
     * Members of the target group.
     */
    @JsonProperty(value = "properties.members", required = true)
    private List<JobTarget> members;

    /**
     * Get members of the target group.
     *
     * @return the members value
     */
    public List<JobTarget> members() {
        return this.members;
    }

    /**
     * Set members of the target group.
     *
     * @param members the members value to set
     * @return the JobTargetGroupInner object itself.
     */
    public JobTargetGroupInner withMembers(List<JobTarget> members) {
        this.members = members;
        return this;
    }

}
