/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of the table in the database full schema.
 */
public class SyncFullSchemaTable {
    /**
     * List of columns in the table of database full schema.
     */
    @JsonProperty(value = "columns", access = JsonProperty.Access.WRITE_ONLY)
    private List<SyncFullSchemaTableColumn> columns;

    /**
     * Error id of the table.
     */
    @JsonProperty(value = "errorId", access = JsonProperty.Access.WRITE_ONLY)
    private String errorId;

    /**
     * If there is error in the table.
     */
    @JsonProperty(value = "hasError", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean hasError;

    /**
     * Name of the table.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * Quoted name of the table.
     */
    @JsonProperty(value = "quotedName", access = JsonProperty.Access.WRITE_ONLY)
    private String quotedName;

    /**
     * Get list of columns in the table of database full schema.
     *
     * @return the columns value
     */
    public List<SyncFullSchemaTableColumn> columns() {
        return this.columns;
    }

    /**
     * Get error id of the table.
     *
     * @return the errorId value
     */
    public String errorId() {
        return this.errorId;
    }

    /**
     * Get if there is error in the table.
     *
     * @return the hasError value
     */
    public Boolean hasError() {
        return this.hasError;
    }

    /**
     * Get name of the table.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get quoted name of the table.
     *
     * @return the quotedName value
     */
    public String quotedName() {
        return this.quotedName;
    }

}
