/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.DataMaskingState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Represents a database data masking policy.
 */
@JsonFlatten
public class DataMaskingPolicyInner extends ProxyResource {
    /**
     * The state of the data masking policy. Possible values include:
     * 'Disabled', 'Enabled'.
     */
    @JsonProperty(value = "properties.dataMaskingState", required = true)
    private DataMaskingState dataMaskingState;

    /**
     * The list of the exempt principals. Specifies the semicolon-separated
     * list of database users for which the data masking policy does not apply.
     * The specified users receive data results without masking for all of the
     * database queries.
     */
    @JsonProperty(value = "properties.exemptPrincipals")
    private String exemptPrincipals;

    /**
     * The list of the application principals. This is a legacy parameter and
     * is no longer used.
     */
    @JsonProperty(value = "properties.applicationPrincipals", access = JsonProperty.Access.WRITE_ONLY)
    private String applicationPrincipals;

    /**
     * The masking level. This is a legacy parameter and is no longer used.
     */
    @JsonProperty(value = "properties.maskingLevel", access = JsonProperty.Access.WRITE_ONLY)
    private String maskingLevel;

    /**
     * The location of the data masking policy.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * The kind of data masking policy. Metadata, used for Azure portal.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * Get the state of the data masking policy. Possible values include: 'Disabled', 'Enabled'.
     *
     * @return the dataMaskingState value
     */
    public DataMaskingState dataMaskingState() {
        return this.dataMaskingState;
    }

    /**
     * Set the state of the data masking policy. Possible values include: 'Disabled', 'Enabled'.
     *
     * @param dataMaskingState the dataMaskingState value to set
     * @return the DataMaskingPolicyInner object itself.
     */
    public DataMaskingPolicyInner withDataMaskingState(DataMaskingState dataMaskingState) {
        this.dataMaskingState = dataMaskingState;
        return this;
    }

    /**
     * Get the list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
     *
     * @return the exemptPrincipals value
     */
    public String exemptPrincipals() {
        return this.exemptPrincipals;
    }

    /**
     * Set the list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
     *
     * @param exemptPrincipals the exemptPrincipals value to set
     * @return the DataMaskingPolicyInner object itself.
     */
    public DataMaskingPolicyInner withExemptPrincipals(String exemptPrincipals) {
        this.exemptPrincipals = exemptPrincipals;
        return this;
    }

    /**
     * Get the list of the application principals. This is a legacy parameter and is no longer used.
     *
     * @return the applicationPrincipals value
     */
    public String applicationPrincipals() {
        return this.applicationPrincipals;
    }

    /**
     * Get the masking level. This is a legacy parameter and is no longer used.
     *
     * @return the maskingLevel value
     */
    public String maskingLevel() {
        return this.maskingLevel;
    }

    /**
     * Get the location of the data masking policy.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the kind of data masking policy. Metadata, used for Azure portal.
     *
     * @return the kind value
     */
    public String kind() {
        return this.kind;
    }

}
