/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;

/**
 * Initializes a new instance of the SqlManagementClientImpl class.
 */
public class SqlManagementClientImpl extends AzureServiceClient {
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The subscription ID that identifies an Azure subscription. */
    private String subscriptionId;

    /**
     * Gets The subscription ID that identifies an Azure subscription.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets The subscription ID that identifies an Azure subscription.
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public SqlManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** The preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets The preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets The preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public SqlManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** The retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public SqlManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public SqlManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The BackupLongTermRetentionPoliciesInner object to access its operations.
     */
    private BackupLongTermRetentionPoliciesInner backupLongTermRetentionPolicies;

    /**
     * Gets the BackupLongTermRetentionPoliciesInner object to access its operations.
     * @return the BackupLongTermRetentionPoliciesInner object.
     */
    public BackupLongTermRetentionPoliciesInner backupLongTermRetentionPolicies() {
        return this.backupLongTermRetentionPolicies;
    }

    /**
     * The BackupLongTermRetentionVaultsInner object to access its operations.
     */
    private BackupLongTermRetentionVaultsInner backupLongTermRetentionVaults;

    /**
     * Gets the BackupLongTermRetentionVaultsInner object to access its operations.
     * @return the BackupLongTermRetentionVaultsInner object.
     */
    public BackupLongTermRetentionVaultsInner backupLongTermRetentionVaults() {
        return this.backupLongTermRetentionVaults;
    }

    /**
     * The RecoverableDatabasesInner object to access its operations.
     */
    private RecoverableDatabasesInner recoverableDatabases;

    /**
     * Gets the RecoverableDatabasesInner object to access its operations.
     * @return the RecoverableDatabasesInner object.
     */
    public RecoverableDatabasesInner recoverableDatabases() {
        return this.recoverableDatabases;
    }

    /**
     * The RestorableDroppedDatabasesInner object to access its operations.
     */
    private RestorableDroppedDatabasesInner restorableDroppedDatabases;

    /**
     * Gets the RestorableDroppedDatabasesInner object to access its operations.
     * @return the RestorableDroppedDatabasesInner object.
     */
    public RestorableDroppedDatabasesInner restorableDroppedDatabases() {
        return this.restorableDroppedDatabases;
    }

    /**
     * The CapabilitiesInner object to access its operations.
     */
    private CapabilitiesInner capabilities;

    /**
     * Gets the CapabilitiesInner object to access its operations.
     * @return the CapabilitiesInner object.
     */
    public CapabilitiesInner capabilities() {
        return this.capabilities;
    }

    /**
     * The ServersInner object to access its operations.
     */
    private ServersInner servers;

    /**
     * Gets the ServersInner object to access its operations.
     * @return the ServersInner object.
     */
    public ServersInner servers() {
        return this.servers;
    }

    /**
     * The ServerConnectionPoliciesInner object to access its operations.
     */
    private ServerConnectionPoliciesInner serverConnectionPolicies;

    /**
     * Gets the ServerConnectionPoliciesInner object to access its operations.
     * @return the ServerConnectionPoliciesInner object.
     */
    public ServerConnectionPoliciesInner serverConnectionPolicies() {
        return this.serverConnectionPolicies;
    }

    /**
     * The DatabasesInner object to access its operations.
     */
    private DatabasesInner databases;

    /**
     * Gets the DatabasesInner object to access its operations.
     * @return the DatabasesInner object.
     */
    public DatabasesInner databases() {
        return this.databases;
    }

    /**
     * The DatabaseThreatDetectionPoliciesInner object to access its operations.
     */
    private DatabaseThreatDetectionPoliciesInner databaseThreatDetectionPolicies;

    /**
     * Gets the DatabaseThreatDetectionPoliciesInner object to access its operations.
     * @return the DatabaseThreatDetectionPoliciesInner object.
     */
    public DatabaseThreatDetectionPoliciesInner databaseThreatDetectionPolicies() {
        return this.databaseThreatDetectionPolicies;
    }

    /**
     * The DataMaskingPoliciesInner object to access its operations.
     */
    private DataMaskingPoliciesInner dataMaskingPolicies;

    /**
     * Gets the DataMaskingPoliciesInner object to access its operations.
     * @return the DataMaskingPoliciesInner object.
     */
    public DataMaskingPoliciesInner dataMaskingPolicies() {
        return this.dataMaskingPolicies;
    }

    /**
     * The DataMaskingRulesInner object to access its operations.
     */
    private DataMaskingRulesInner dataMaskingRules;

    /**
     * Gets the DataMaskingRulesInner object to access its operations.
     * @return the DataMaskingRulesInner object.
     */
    public DataMaskingRulesInner dataMaskingRules() {
        return this.dataMaskingRules;
    }

    /**
     * The ElasticPoolsInner object to access its operations.
     */
    private ElasticPoolsInner elasticPools;

    /**
     * Gets the ElasticPoolsInner object to access its operations.
     * @return the ElasticPoolsInner object.
     */
    public ElasticPoolsInner elasticPools() {
        return this.elasticPools;
    }

    /**
     * The FirewallRulesInner object to access its operations.
     */
    private FirewallRulesInner firewallRules;

    /**
     * Gets the FirewallRulesInner object to access its operations.
     * @return the FirewallRulesInner object.
     */
    public FirewallRulesInner firewallRules() {
        return this.firewallRules;
    }

    /**
     * The GeoBackupPoliciesInner object to access its operations.
     */
    private GeoBackupPoliciesInner geoBackupPolicies;

    /**
     * Gets the GeoBackupPoliciesInner object to access its operations.
     * @return the GeoBackupPoliciesInner object.
     */
    public GeoBackupPoliciesInner geoBackupPolicies() {
        return this.geoBackupPolicies;
    }

    /**
     * The RecommendedElasticPoolsInner object to access its operations.
     */
    private RecommendedElasticPoolsInner recommendedElasticPools;

    /**
     * Gets the RecommendedElasticPoolsInner object to access its operations.
     * @return the RecommendedElasticPoolsInner object.
     */
    public RecommendedElasticPoolsInner recommendedElasticPools() {
        return this.recommendedElasticPools;
    }

    /**
     * The ReplicationLinksInner object to access its operations.
     */
    private ReplicationLinksInner replicationLinks;

    /**
     * Gets the ReplicationLinksInner object to access its operations.
     * @return the ReplicationLinksInner object.
     */
    public ReplicationLinksInner replicationLinks() {
        return this.replicationLinks;
    }

    /**
     * The ServerAzureADAdministratorsInner object to access its operations.
     */
    private ServerAzureADAdministratorsInner serverAzureADAdministrators;

    /**
     * Gets the ServerAzureADAdministratorsInner object to access its operations.
     * @return the ServerAzureADAdministratorsInner object.
     */
    public ServerAzureADAdministratorsInner serverAzureADAdministrators() {
        return this.serverAzureADAdministrators;
    }

    /**
     * The ServerCommunicationLinksInner object to access its operations.
     */
    private ServerCommunicationLinksInner serverCommunicationLinks;

    /**
     * Gets the ServerCommunicationLinksInner object to access its operations.
     * @return the ServerCommunicationLinksInner object.
     */
    public ServerCommunicationLinksInner serverCommunicationLinks() {
        return this.serverCommunicationLinks;
    }

    /**
     * The ServiceObjectivesInner object to access its operations.
     */
    private ServiceObjectivesInner serviceObjectives;

    /**
     * Gets the ServiceObjectivesInner object to access its operations.
     * @return the ServiceObjectivesInner object.
     */
    public ServiceObjectivesInner serviceObjectives() {
        return this.serviceObjectives;
    }

    /**
     * The ElasticPoolActivitiesInner object to access its operations.
     */
    private ElasticPoolActivitiesInner elasticPoolActivities;

    /**
     * Gets the ElasticPoolActivitiesInner object to access its operations.
     * @return the ElasticPoolActivitiesInner object.
     */
    public ElasticPoolActivitiesInner elasticPoolActivities() {
        return this.elasticPoolActivities;
    }

    /**
     * The ElasticPoolDatabaseActivitiesInner object to access its operations.
     */
    private ElasticPoolDatabaseActivitiesInner elasticPoolDatabaseActivities;

    /**
     * Gets the ElasticPoolDatabaseActivitiesInner object to access its operations.
     * @return the ElasticPoolDatabaseActivitiesInner object.
     */
    public ElasticPoolDatabaseActivitiesInner elasticPoolDatabaseActivities() {
        return this.elasticPoolDatabaseActivities;
    }

    /**
     * The ServiceTierAdvisorsInner object to access its operations.
     */
    private ServiceTierAdvisorsInner serviceTierAdvisors;

    /**
     * Gets the ServiceTierAdvisorsInner object to access its operations.
     * @return the ServiceTierAdvisorsInner object.
     */
    public ServiceTierAdvisorsInner serviceTierAdvisors() {
        return this.serviceTierAdvisors;
    }

    /**
     * The TransparentDataEncryptionsInner object to access its operations.
     */
    private TransparentDataEncryptionsInner transparentDataEncryptions;

    /**
     * Gets the TransparentDataEncryptionsInner object to access its operations.
     * @return the TransparentDataEncryptionsInner object.
     */
    public TransparentDataEncryptionsInner transparentDataEncryptions() {
        return this.transparentDataEncryptions;
    }

    /**
     * The TransparentDataEncryptionActivitiesInner object to access its operations.
     */
    private TransparentDataEncryptionActivitiesInner transparentDataEncryptionActivities;

    /**
     * Gets the TransparentDataEncryptionActivitiesInner object to access its operations.
     * @return the TransparentDataEncryptionActivitiesInner object.
     */
    public TransparentDataEncryptionActivitiesInner transparentDataEncryptionActivities() {
        return this.transparentDataEncryptionActivities;
    }

    /**
     * The ServerUsagesInner object to access its operations.
     */
    private ServerUsagesInner serverUsages;

    /**
     * Gets the ServerUsagesInner object to access its operations.
     * @return the ServerUsagesInner object.
     */
    public ServerUsagesInner serverUsages() {
        return this.serverUsages;
    }

    /**
     * The DatabaseUsagesInner object to access its operations.
     */
    private DatabaseUsagesInner databaseUsages;

    /**
     * Gets the DatabaseUsagesInner object to access its operations.
     * @return the DatabaseUsagesInner object.
     */
    public DatabaseUsagesInner databaseUsages() {
        return this.databaseUsages;
    }

    /**
     * The DatabaseAutomaticTuningsInner object to access its operations.
     */
    private DatabaseAutomaticTuningsInner databaseAutomaticTunings;

    /**
     * Gets the DatabaseAutomaticTuningsInner object to access its operations.
     * @return the DatabaseAutomaticTuningsInner object.
     */
    public DatabaseAutomaticTuningsInner databaseAutomaticTunings() {
        return this.databaseAutomaticTunings;
    }

    /**
     * The EncryptionProtectorsInner object to access its operations.
     */
    private EncryptionProtectorsInner encryptionProtectors;

    /**
     * Gets the EncryptionProtectorsInner object to access its operations.
     * @return the EncryptionProtectorsInner object.
     */
    public EncryptionProtectorsInner encryptionProtectors() {
        return this.encryptionProtectors;
    }

    /**
     * The FailoverGroupsInner object to access its operations.
     */
    private FailoverGroupsInner failoverGroups;

    /**
     * Gets the FailoverGroupsInner object to access its operations.
     * @return the FailoverGroupsInner object.
     */
    public FailoverGroupsInner failoverGroups() {
        return this.failoverGroups;
    }

    /**
     * The OperationsInner object to access its operations.
     */
    private OperationsInner operations;

    /**
     * Gets the OperationsInner object to access its operations.
     * @return the OperationsInner object.
     */
    public OperationsInner operations() {
        return this.operations;
    }

    /**
     * The ServerKeysInner object to access its operations.
     */
    private ServerKeysInner serverKeys;

    /**
     * Gets the ServerKeysInner object to access its operations.
     * @return the ServerKeysInner object.
     */
    public ServerKeysInner serverKeys() {
        return this.serverKeys;
    }

    /**
     * The SyncAgentsInner object to access its operations.
     */
    private SyncAgentsInner syncAgents;

    /**
     * Gets the SyncAgentsInner object to access its operations.
     * @return the SyncAgentsInner object.
     */
    public SyncAgentsInner syncAgents() {
        return this.syncAgents;
    }

    /**
     * The SyncGroupsInner object to access its operations.
     */
    private SyncGroupsInner syncGroups;

    /**
     * Gets the SyncGroupsInner object to access its operations.
     * @return the SyncGroupsInner object.
     */
    public SyncGroupsInner syncGroups() {
        return this.syncGroups;
    }

    /**
     * The SyncMembersInner object to access its operations.
     */
    private SyncMembersInner syncMembers;

    /**
     * Gets the SyncMembersInner object to access its operations.
     * @return the SyncMembersInner object.
     */
    public SyncMembersInner syncMembers() {
        return this.syncMembers;
    }

    /**
     * The SubscriptionUsagesInner object to access its operations.
     */
    private SubscriptionUsagesInner subscriptionUsages;

    /**
     * Gets the SubscriptionUsagesInner object to access its operations.
     * @return the SubscriptionUsagesInner object.
     */
    public SubscriptionUsagesInner subscriptionUsages() {
        return this.subscriptionUsages;
    }

    /**
     * The VirtualClustersInner object to access its operations.
     */
    private VirtualClustersInner virtualClusters;

    /**
     * Gets the VirtualClustersInner object to access its operations.
     * @return the VirtualClustersInner object.
     */
    public VirtualClustersInner virtualClusters() {
        return this.virtualClusters;
    }

    /**
     * The VirtualNetworkRulesInner object to access its operations.
     */
    private VirtualNetworkRulesInner virtualNetworkRules;

    /**
     * Gets the VirtualNetworkRulesInner object to access its operations.
     * @return the VirtualNetworkRulesInner object.
     */
    public VirtualNetworkRulesInner virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    /**
     * The ExtendedDatabaseBlobAuditingPoliciesInner object to access its operations.
     */
    private ExtendedDatabaseBlobAuditingPoliciesInner extendedDatabaseBlobAuditingPolicies;

    /**
     * Gets the ExtendedDatabaseBlobAuditingPoliciesInner object to access its operations.
     * @return the ExtendedDatabaseBlobAuditingPoliciesInner object.
     */
    public ExtendedDatabaseBlobAuditingPoliciesInner extendedDatabaseBlobAuditingPolicies() {
        return this.extendedDatabaseBlobAuditingPolicies;
    }

    /**
     * The ExtendedServerBlobAuditingPoliciesInner object to access its operations.
     */
    private ExtendedServerBlobAuditingPoliciesInner extendedServerBlobAuditingPolicies;

    /**
     * Gets the ExtendedServerBlobAuditingPoliciesInner object to access its operations.
     * @return the ExtendedServerBlobAuditingPoliciesInner object.
     */
    public ExtendedServerBlobAuditingPoliciesInner extendedServerBlobAuditingPolicies() {
        return this.extendedServerBlobAuditingPolicies;
    }

    /**
     * The ServerBlobAuditingPoliciesInner object to access its operations.
     */
    private ServerBlobAuditingPoliciesInner serverBlobAuditingPolicies;

    /**
     * Gets the ServerBlobAuditingPoliciesInner object to access its operations.
     * @return the ServerBlobAuditingPoliciesInner object.
     */
    public ServerBlobAuditingPoliciesInner serverBlobAuditingPolicies() {
        return this.serverBlobAuditingPolicies;
    }

    /**
     * The DatabaseBlobAuditingPoliciesInner object to access its operations.
     */
    private DatabaseBlobAuditingPoliciesInner databaseBlobAuditingPolicies;

    /**
     * Gets the DatabaseBlobAuditingPoliciesInner object to access its operations.
     * @return the DatabaseBlobAuditingPoliciesInner object.
     */
    public DatabaseBlobAuditingPoliciesInner databaseBlobAuditingPolicies() {
        return this.databaseBlobAuditingPolicies;
    }

    /**
     * The DatabaseVulnerabilityAssessmentRuleBaselinesInner object to access its operations.
     */
    private DatabaseVulnerabilityAssessmentRuleBaselinesInner databaseVulnerabilityAssessmentRuleBaselines;

    /**
     * Gets the DatabaseVulnerabilityAssessmentRuleBaselinesInner object to access its operations.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselinesInner object.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselinesInner databaseVulnerabilityAssessmentRuleBaselines() {
        return this.databaseVulnerabilityAssessmentRuleBaselines;
    }

    /**
     * The DatabaseVulnerabilityAssessmentsInner object to access its operations.
     */
    private DatabaseVulnerabilityAssessmentsInner databaseVulnerabilityAssessments;

    /**
     * Gets the DatabaseVulnerabilityAssessmentsInner object to access its operations.
     * @return the DatabaseVulnerabilityAssessmentsInner object.
     */
    public DatabaseVulnerabilityAssessmentsInner databaseVulnerabilityAssessments() {
        return this.databaseVulnerabilityAssessments;
    }

    /**
     * The JobAgentsInner object to access its operations.
     */
    private JobAgentsInner jobAgents;

    /**
     * Gets the JobAgentsInner object to access its operations.
     * @return the JobAgentsInner object.
     */
    public JobAgentsInner jobAgents() {
        return this.jobAgents;
    }

    /**
     * The JobCredentialsInner object to access its operations.
     */
    private JobCredentialsInner jobCredentials;

    /**
     * Gets the JobCredentialsInner object to access its operations.
     * @return the JobCredentialsInner object.
     */
    public JobCredentialsInner jobCredentials() {
        return this.jobCredentials;
    }

    /**
     * The JobExecutionsInner object to access its operations.
     */
    private JobExecutionsInner jobExecutions;

    /**
     * Gets the JobExecutionsInner object to access its operations.
     * @return the JobExecutionsInner object.
     */
    public JobExecutionsInner jobExecutions() {
        return this.jobExecutions;
    }

    /**
     * The JobsInner object to access its operations.
     */
    private JobsInner jobs;

    /**
     * Gets the JobsInner object to access its operations.
     * @return the JobsInner object.
     */
    public JobsInner jobs() {
        return this.jobs;
    }

    /**
     * The JobStepExecutionsInner object to access its operations.
     */
    private JobStepExecutionsInner jobStepExecutions;

    /**
     * Gets the JobStepExecutionsInner object to access its operations.
     * @return the JobStepExecutionsInner object.
     */
    public JobStepExecutionsInner jobStepExecutions() {
        return this.jobStepExecutions;
    }

    /**
     * The JobStepsInner object to access its operations.
     */
    private JobStepsInner jobSteps;

    /**
     * Gets the JobStepsInner object to access its operations.
     * @return the JobStepsInner object.
     */
    public JobStepsInner jobSteps() {
        return this.jobSteps;
    }

    /**
     * The JobTargetExecutionsInner object to access its operations.
     */
    private JobTargetExecutionsInner jobTargetExecutions;

    /**
     * Gets the JobTargetExecutionsInner object to access its operations.
     * @return the JobTargetExecutionsInner object.
     */
    public JobTargetExecutionsInner jobTargetExecutions() {
        return this.jobTargetExecutions;
    }

    /**
     * The JobTargetGroupsInner object to access its operations.
     */
    private JobTargetGroupsInner jobTargetGroups;

    /**
     * Gets the JobTargetGroupsInner object to access its operations.
     * @return the JobTargetGroupsInner object.
     */
    public JobTargetGroupsInner jobTargetGroups() {
        return this.jobTargetGroups;
    }

    /**
     * The JobVersionsInner object to access its operations.
     */
    private JobVersionsInner jobVersions;

    /**
     * Gets the JobVersionsInner object to access its operations.
     * @return the JobVersionsInner object.
     */
    public JobVersionsInner jobVersions() {
        return this.jobVersions;
    }

    /**
     * The ManagedBackupShortTermRetentionPoliciesInner object to access its operations.
     */
    private ManagedBackupShortTermRetentionPoliciesInner managedBackupShortTermRetentionPolicies;

    /**
     * Gets the ManagedBackupShortTermRetentionPoliciesInner object to access its operations.
     * @return the ManagedBackupShortTermRetentionPoliciesInner object.
     */
    public ManagedBackupShortTermRetentionPoliciesInner managedBackupShortTermRetentionPolicies() {
        return this.managedBackupShortTermRetentionPolicies;
    }

    /**
     * The ManagedDatabasesInner object to access its operations.
     */
    private ManagedDatabasesInner managedDatabases;

    /**
     * Gets the ManagedDatabasesInner object to access its operations.
     * @return the ManagedDatabasesInner object.
     */
    public ManagedDatabasesInner managedDatabases() {
        return this.managedDatabases;
    }

    /**
     * The ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner object to access its operations.
     */
    private ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies;

    /**
     * Gets the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner object to access its operations.
     * @return the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner object.
     */
    public ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies() {
        return this.managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies;
    }

    /**
     * The ServerAutomaticTuningsInner object to access its operations.
     */
    private ServerAutomaticTuningsInner serverAutomaticTunings;

    /**
     * Gets the ServerAutomaticTuningsInner object to access its operations.
     * @return the ServerAutomaticTuningsInner object.
     */
    public ServerAutomaticTuningsInner serverAutomaticTunings() {
        return this.serverAutomaticTunings;
    }

    /**
     * The ServerDnsAliasesInner object to access its operations.
     */
    private ServerDnsAliasesInner serverDnsAliases;

    /**
     * Gets the ServerDnsAliasesInner object to access its operations.
     * @return the ServerDnsAliasesInner object.
     */
    public ServerDnsAliasesInner serverDnsAliases() {
        return this.serverDnsAliases;
    }

    /**
     * The ServerSecurityAlertPoliciesInner object to access its operations.
     */
    private ServerSecurityAlertPoliciesInner serverSecurityAlertPolicies;

    /**
     * Gets the ServerSecurityAlertPoliciesInner object to access its operations.
     * @return the ServerSecurityAlertPoliciesInner object.
     */
    public ServerSecurityAlertPoliciesInner serverSecurityAlertPolicies() {
        return this.serverSecurityAlertPolicies;
    }

    /**
     * The RestorableDroppedManagedDatabasesInner object to access its operations.
     */
    private RestorableDroppedManagedDatabasesInner restorableDroppedManagedDatabases;

    /**
     * Gets the RestorableDroppedManagedDatabasesInner object to access its operations.
     * @return the RestorableDroppedManagedDatabasesInner object.
     */
    public RestorableDroppedManagedDatabasesInner restorableDroppedManagedDatabases() {
        return this.restorableDroppedManagedDatabases;
    }

    /**
     * The RestorePointsInner object to access its operations.
     */
    private RestorePointsInner restorePoints;

    /**
     * Gets the RestorePointsInner object to access its operations.
     * @return the RestorePointsInner object.
     */
    public RestorePointsInner restorePoints() {
        return this.restorePoints;
    }

    /**
     * The ManagedDatabaseSecurityAlertPoliciesInner object to access its operations.
     */
    private ManagedDatabaseSecurityAlertPoliciesInner managedDatabaseSecurityAlertPolicies;

    /**
     * Gets the ManagedDatabaseSecurityAlertPoliciesInner object to access its operations.
     * @return the ManagedDatabaseSecurityAlertPoliciesInner object.
     */
    public ManagedDatabaseSecurityAlertPoliciesInner managedDatabaseSecurityAlertPolicies() {
        return this.managedDatabaseSecurityAlertPolicies;
    }

    /**
     * The ManagedServerSecurityAlertPoliciesInner object to access its operations.
     */
    private ManagedServerSecurityAlertPoliciesInner managedServerSecurityAlertPolicies;

    /**
     * Gets the ManagedServerSecurityAlertPoliciesInner object to access its operations.
     * @return the ManagedServerSecurityAlertPoliciesInner object.
     */
    public ManagedServerSecurityAlertPoliciesInner managedServerSecurityAlertPolicies() {
        return this.managedServerSecurityAlertPolicies;
    }

    /**
     * The SensitivityLabelsInner object to access its operations.
     */
    private SensitivityLabelsInner sensitivityLabels;

    /**
     * Gets the SensitivityLabelsInner object to access its operations.
     * @return the SensitivityLabelsInner object.
     */
    public SensitivityLabelsInner sensitivityLabels() {
        return this.sensitivityLabels;
    }

    /**
     * The DatabaseOperationsInner object to access its operations.
     */
    private DatabaseOperationsInner databaseOperations;

    /**
     * Gets the DatabaseOperationsInner object to access its operations.
     * @return the DatabaseOperationsInner object.
     */
    public DatabaseOperationsInner databaseOperations() {
        return this.databaseOperations;
    }

    /**
     * The ElasticPoolOperationsInner object to access its operations.
     */
    private ElasticPoolOperationsInner elasticPoolOperations;

    /**
     * Gets the ElasticPoolOperationsInner object to access its operations.
     * @return the ElasticPoolOperationsInner object.
     */
    public ElasticPoolOperationsInner elasticPoolOperations() {
        return this.elasticPoolOperations;
    }

    /**
     * The DatabaseVulnerabilityAssessmentScansInner object to access its operations.
     */
    private DatabaseVulnerabilityAssessmentScansInner databaseVulnerabilityAssessmentScans;

    /**
     * Gets the DatabaseVulnerabilityAssessmentScansInner object to access its operations.
     * @return the DatabaseVulnerabilityAssessmentScansInner object.
     */
    public DatabaseVulnerabilityAssessmentScansInner databaseVulnerabilityAssessmentScans() {
        return this.databaseVulnerabilityAssessmentScans;
    }

    /**
     * The ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner object to access its operations.
     */
    private ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner managedDatabaseVulnerabilityAssessmentRuleBaselines;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner object to access its operations.
     * @return the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner object.
     */
    public ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner managedDatabaseVulnerabilityAssessmentRuleBaselines() {
        return this.managedDatabaseVulnerabilityAssessmentRuleBaselines;
    }

    /**
     * The ManagedDatabaseVulnerabilityAssessmentScansInner object to access its operations.
     */
    private ManagedDatabaseVulnerabilityAssessmentScansInner managedDatabaseVulnerabilityAssessmentScans;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentScansInner object to access its operations.
     * @return the ManagedDatabaseVulnerabilityAssessmentScansInner object.
     */
    public ManagedDatabaseVulnerabilityAssessmentScansInner managedDatabaseVulnerabilityAssessmentScans() {
        return this.managedDatabaseVulnerabilityAssessmentScans;
    }

    /**
     * The ManagedDatabaseVulnerabilityAssessmentsInner object to access its operations.
     */
    private ManagedDatabaseVulnerabilityAssessmentsInner managedDatabaseVulnerabilityAssessments;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentsInner object to access its operations.
     * @return the ManagedDatabaseVulnerabilityAssessmentsInner object.
     */
    public ManagedDatabaseVulnerabilityAssessmentsInner managedDatabaseVulnerabilityAssessments() {
        return this.managedDatabaseVulnerabilityAssessments;
    }

    /**
     * The InstanceFailoverGroupsInner object to access its operations.
     */
    private InstanceFailoverGroupsInner instanceFailoverGroups;

    /**
     * Gets the InstanceFailoverGroupsInner object to access its operations.
     * @return the InstanceFailoverGroupsInner object.
     */
    public InstanceFailoverGroupsInner instanceFailoverGroups() {
        return this.instanceFailoverGroups;
    }

    /**
     * The BackupShortTermRetentionPoliciesInner object to access its operations.
     */
    private BackupShortTermRetentionPoliciesInner backupShortTermRetentionPolicies;

    /**
     * Gets the BackupShortTermRetentionPoliciesInner object to access its operations.
     * @return the BackupShortTermRetentionPoliciesInner object.
     */
    public BackupShortTermRetentionPoliciesInner backupShortTermRetentionPolicies() {
        return this.backupShortTermRetentionPolicies;
    }

    /**
     * The TdeCertificatesInner object to access its operations.
     */
    private TdeCertificatesInner tdeCertificates;

    /**
     * Gets the TdeCertificatesInner object to access its operations.
     * @return the TdeCertificatesInner object.
     */
    public TdeCertificatesInner tdeCertificates() {
        return this.tdeCertificates;
    }

    /**
     * The ManagedInstanceTdeCertificatesInner object to access its operations.
     */
    private ManagedInstanceTdeCertificatesInner managedInstanceTdeCertificates;

    /**
     * Gets the ManagedInstanceTdeCertificatesInner object to access its operations.
     * @return the ManagedInstanceTdeCertificatesInner object.
     */
    public ManagedInstanceTdeCertificatesInner managedInstanceTdeCertificates() {
        return this.managedInstanceTdeCertificates;
    }

    /**
     * The ManagedInstanceKeysInner object to access its operations.
     */
    private ManagedInstanceKeysInner managedInstanceKeys;

    /**
     * Gets the ManagedInstanceKeysInner object to access its operations.
     * @return the ManagedInstanceKeysInner object.
     */
    public ManagedInstanceKeysInner managedInstanceKeys() {
        return this.managedInstanceKeys;
    }

    /**
     * The ManagedInstanceEncryptionProtectorsInner object to access its operations.
     */
    private ManagedInstanceEncryptionProtectorsInner managedInstanceEncryptionProtectors;

    /**
     * Gets the ManagedInstanceEncryptionProtectorsInner object to access its operations.
     * @return the ManagedInstanceEncryptionProtectorsInner object.
     */
    public ManagedInstanceEncryptionProtectorsInner managedInstanceEncryptionProtectors() {
        return this.managedInstanceEncryptionProtectors;
    }

    /**
     * The RecoverableManagedDatabasesInner object to access its operations.
     */
    private RecoverableManagedDatabasesInner recoverableManagedDatabases;

    /**
     * Gets the RecoverableManagedDatabasesInner object to access its operations.
     * @return the RecoverableManagedDatabasesInner object.
     */
    public RecoverableManagedDatabasesInner recoverableManagedDatabases() {
        return this.recoverableManagedDatabases;
    }

    /**
     * The ManagedInstanceVulnerabilityAssessmentsInner object to access its operations.
     */
    private ManagedInstanceVulnerabilityAssessmentsInner managedInstanceVulnerabilityAssessments;

    /**
     * Gets the ManagedInstanceVulnerabilityAssessmentsInner object to access its operations.
     * @return the ManagedInstanceVulnerabilityAssessmentsInner object.
     */
    public ManagedInstanceVulnerabilityAssessmentsInner managedInstanceVulnerabilityAssessments() {
        return this.managedInstanceVulnerabilityAssessments;
    }

    /**
     * The ServerVulnerabilityAssessmentsInner object to access its operations.
     */
    private ServerVulnerabilityAssessmentsInner serverVulnerabilityAssessments;

    /**
     * Gets the ServerVulnerabilityAssessmentsInner object to access its operations.
     * @return the ServerVulnerabilityAssessmentsInner object.
     */
    public ServerVulnerabilityAssessmentsInner serverVulnerabilityAssessments() {
        return this.serverVulnerabilityAssessments;
    }

    /**
     * The ManagedDatabaseSensitivityLabelsInner object to access its operations.
     */
    private ManagedDatabaseSensitivityLabelsInner managedDatabaseSensitivityLabels;

    /**
     * Gets the ManagedDatabaseSensitivityLabelsInner object to access its operations.
     * @return the ManagedDatabaseSensitivityLabelsInner object.
     */
    public ManagedDatabaseSensitivityLabelsInner managedDatabaseSensitivityLabels() {
        return this.managedDatabaseSensitivityLabels;
    }

    /**
     * The InstancePoolsInner object to access its operations.
     */
    private InstancePoolsInner instancePools;

    /**
     * Gets the InstancePoolsInner object to access its operations.
     * @return the InstancePoolsInner object.
     */
    public InstancePoolsInner instancePools() {
        return this.instancePools;
    }

    /**
     * The UsagesInner object to access its operations.
     */
    private UsagesInner usages;

    /**
     * Gets the UsagesInner object to access its operations.
     * @return the UsagesInner object.
     */
    public UsagesInner usages() {
        return this.usages;
    }

    /**
     * The ManagedInstancesInner object to access its operations.
     */
    private ManagedInstancesInner managedInstances;

    /**
     * Gets the ManagedInstancesInner object to access its operations.
     * @return the ManagedInstancesInner object.
     */
    public ManagedInstancesInner managedInstances() {
        return this.managedInstances;
    }

    /**
     * Initializes an instance of SqlManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public SqlManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of SqlManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public SqlManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of SqlManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public SqlManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.backupLongTermRetentionPolicies = new BackupLongTermRetentionPoliciesInner(restClient().retrofit(), this);
        this.backupLongTermRetentionVaults = new BackupLongTermRetentionVaultsInner(restClient().retrofit(), this);
        this.recoverableDatabases = new RecoverableDatabasesInner(restClient().retrofit(), this);
        this.restorableDroppedDatabases = new RestorableDroppedDatabasesInner(restClient().retrofit(), this);
        this.capabilities = new CapabilitiesInner(restClient().retrofit(), this);
        this.servers = new ServersInner(restClient().retrofit(), this);
        this.serverConnectionPolicies = new ServerConnectionPoliciesInner(restClient().retrofit(), this);
        this.databases = new DatabasesInner(restClient().retrofit(), this);
        this.databaseThreatDetectionPolicies = new DatabaseThreatDetectionPoliciesInner(restClient().retrofit(), this);
        this.dataMaskingPolicies = new DataMaskingPoliciesInner(restClient().retrofit(), this);
        this.dataMaskingRules = new DataMaskingRulesInner(restClient().retrofit(), this);
        this.elasticPools = new ElasticPoolsInner(restClient().retrofit(), this);
        this.firewallRules = new FirewallRulesInner(restClient().retrofit(), this);
        this.geoBackupPolicies = new GeoBackupPoliciesInner(restClient().retrofit(), this);
        this.recommendedElasticPools = new RecommendedElasticPoolsInner(restClient().retrofit(), this);
        this.replicationLinks = new ReplicationLinksInner(restClient().retrofit(), this);
        this.serverAzureADAdministrators = new ServerAzureADAdministratorsInner(restClient().retrofit(), this);
        this.serverCommunicationLinks = new ServerCommunicationLinksInner(restClient().retrofit(), this);
        this.serviceObjectives = new ServiceObjectivesInner(restClient().retrofit(), this);
        this.elasticPoolActivities = new ElasticPoolActivitiesInner(restClient().retrofit(), this);
        this.elasticPoolDatabaseActivities = new ElasticPoolDatabaseActivitiesInner(restClient().retrofit(), this);
        this.serviceTierAdvisors = new ServiceTierAdvisorsInner(restClient().retrofit(), this);
        this.transparentDataEncryptions = new TransparentDataEncryptionsInner(restClient().retrofit(), this);
        this.transparentDataEncryptionActivities = new TransparentDataEncryptionActivitiesInner(restClient().retrofit(), this);
        this.serverUsages = new ServerUsagesInner(restClient().retrofit(), this);
        this.databaseUsages = new DatabaseUsagesInner(restClient().retrofit(), this);
        this.databaseAutomaticTunings = new DatabaseAutomaticTuningsInner(restClient().retrofit(), this);
        this.encryptionProtectors = new EncryptionProtectorsInner(restClient().retrofit(), this);
        this.failoverGroups = new FailoverGroupsInner(restClient().retrofit(), this);
        this.operations = new OperationsInner(restClient().retrofit(), this);
        this.serverKeys = new ServerKeysInner(restClient().retrofit(), this);
        this.syncAgents = new SyncAgentsInner(restClient().retrofit(), this);
        this.syncGroups = new SyncGroupsInner(restClient().retrofit(), this);
        this.syncMembers = new SyncMembersInner(restClient().retrofit(), this);
        this.subscriptionUsages = new SubscriptionUsagesInner(restClient().retrofit(), this);
        this.virtualClusters = new VirtualClustersInner(restClient().retrofit(), this);
        this.virtualNetworkRules = new VirtualNetworkRulesInner(restClient().retrofit(), this);
        this.extendedDatabaseBlobAuditingPolicies = new ExtendedDatabaseBlobAuditingPoliciesInner(restClient().retrofit(), this);
        this.extendedServerBlobAuditingPolicies = new ExtendedServerBlobAuditingPoliciesInner(restClient().retrofit(), this);
        this.serverBlobAuditingPolicies = new ServerBlobAuditingPoliciesInner(restClient().retrofit(), this);
        this.databaseBlobAuditingPolicies = new DatabaseBlobAuditingPoliciesInner(restClient().retrofit(), this);
        this.databaseVulnerabilityAssessmentRuleBaselines = new DatabaseVulnerabilityAssessmentRuleBaselinesInner(restClient().retrofit(), this);
        this.databaseVulnerabilityAssessments = new DatabaseVulnerabilityAssessmentsInner(restClient().retrofit(), this);
        this.jobAgents = new JobAgentsInner(restClient().retrofit(), this);
        this.jobCredentials = new JobCredentialsInner(restClient().retrofit(), this);
        this.jobExecutions = new JobExecutionsInner(restClient().retrofit(), this);
        this.jobs = new JobsInner(restClient().retrofit(), this);
        this.jobStepExecutions = new JobStepExecutionsInner(restClient().retrofit(), this);
        this.jobSteps = new JobStepsInner(restClient().retrofit(), this);
        this.jobTargetExecutions = new JobTargetExecutionsInner(restClient().retrofit(), this);
        this.jobTargetGroups = new JobTargetGroupsInner(restClient().retrofit(), this);
        this.jobVersions = new JobVersionsInner(restClient().retrofit(), this);
        this.managedBackupShortTermRetentionPolicies = new ManagedBackupShortTermRetentionPoliciesInner(restClient().retrofit(), this);
        this.managedDatabases = new ManagedDatabasesInner(restClient().retrofit(), this);
        this.managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies = new ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner(restClient().retrofit(), this);
        this.serverAutomaticTunings = new ServerAutomaticTuningsInner(restClient().retrofit(), this);
        this.serverDnsAliases = new ServerDnsAliasesInner(restClient().retrofit(), this);
        this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesInner(restClient().retrofit(), this);
        this.restorableDroppedManagedDatabases = new RestorableDroppedManagedDatabasesInner(restClient().retrofit(), this);
        this.restorePoints = new RestorePointsInner(restClient().retrofit(), this);
        this.managedDatabaseSecurityAlertPolicies = new ManagedDatabaseSecurityAlertPoliciesInner(restClient().retrofit(), this);
        this.managedServerSecurityAlertPolicies = new ManagedServerSecurityAlertPoliciesInner(restClient().retrofit(), this);
        this.sensitivityLabels = new SensitivityLabelsInner(restClient().retrofit(), this);
        this.databaseOperations = new DatabaseOperationsInner(restClient().retrofit(), this);
        this.elasticPoolOperations = new ElasticPoolOperationsInner(restClient().retrofit(), this);
        this.databaseVulnerabilityAssessmentScans = new DatabaseVulnerabilityAssessmentScansInner(restClient().retrofit(), this);
        this.managedDatabaseVulnerabilityAssessmentRuleBaselines = new ManagedDatabaseVulnerabilityAssessmentRuleBaselinesInner(restClient().retrofit(), this);
        this.managedDatabaseVulnerabilityAssessmentScans = new ManagedDatabaseVulnerabilityAssessmentScansInner(restClient().retrofit(), this);
        this.managedDatabaseVulnerabilityAssessments = new ManagedDatabaseVulnerabilityAssessmentsInner(restClient().retrofit(), this);
        this.instanceFailoverGroups = new InstanceFailoverGroupsInner(restClient().retrofit(), this);
        this.backupShortTermRetentionPolicies = new BackupShortTermRetentionPoliciesInner(restClient().retrofit(), this);
        this.tdeCertificates = new TdeCertificatesInner(restClient().retrofit(), this);
        this.managedInstanceTdeCertificates = new ManagedInstanceTdeCertificatesInner(restClient().retrofit(), this);
        this.managedInstanceKeys = new ManagedInstanceKeysInner(restClient().retrofit(), this);
        this.managedInstanceEncryptionProtectors = new ManagedInstanceEncryptionProtectorsInner(restClient().retrofit(), this);
        this.recoverableManagedDatabases = new RecoverableManagedDatabasesInner(restClient().retrofit(), this);
        this.managedInstanceVulnerabilityAssessments = new ManagedInstanceVulnerabilityAssessmentsInner(restClient().retrofit(), this);
        this.serverVulnerabilityAssessments = new ServerVulnerabilityAssessmentsInner(restClient().retrofit(), this);
        this.managedDatabaseSensitivityLabels = new ManagedDatabaseSensitivityLabelsInner(restClient().retrofit(), this);
        this.instancePools = new InstancePoolsInner(restClient().retrofit(), this);
        this.usages = new UsagesInner(restClient().retrofit(), this);
        this.managedInstances = new ManagedInstancesInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "SqlManagementClient");
    }
}
