/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies.
 */
public class ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner {
    /** The Retrofit service to perform REST calls. */
    private ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ManagedBackupShortTermRetentionPolicyInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ManagedBackupShortTermRetentionPolicyInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ManagedBackupShortTermRetentionPolicyInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ManagedBackupShortTermRetentionPolicyInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies listByRestorableDroppedDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies")
        Observable<Response<ResponseBody>> listByRestorableDroppedDatabase(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies listByRestorableDroppedDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listByRestorableDroppedDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a dropped database's short term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner get(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single().body();
    }

    /**
     * Gets a dropped database's short term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Gets a dropped database's short term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a dropped database's short term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedBackupShortTermRetentionPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().last().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        final Integer retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType());
    }
    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).toBlocking().last().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType());
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        final Integer retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).toBlocking().single().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedBackupShortTermRetentionPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().last().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        final Integer retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType());
    }
    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).toBlocking().last().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType());
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        final Integer retentionDays = null;
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return service.beginUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedBackupShortTermRetentionPolicyInner object if successful.
     */
    public ManagedBackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).toBlocking().single().body();
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays, final ServiceCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays), serviceCallback);
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, retentionDays).map(new Func1<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner>() {
            @Override
            public ManagedBackupShortTermRetentionPolicyInner call(ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Sets a database's long term retention policy.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedBackupShortTermRetentionPolicyInner object
     */
    public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String policyName = "default";
        final String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return service.beginUpdate(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedBackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedBackupShortTermRetentionPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedBackupShortTermRetentionPolicyInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedBackupShortTermRetentionPolicyInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object if successful.
     */
    public PagedList<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabase(final String resourceGroupName, final String managedInstanceName, final String restorableDroppedDatabaseId) {
        ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response = listByRestorableDroppedDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single();
        return new PagedList<ManagedBackupShortTermRetentionPolicyInner>(response.body()) {
            @Override
            public Page<ManagedBackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseAsync(final String resourceGroupName, final String managedInstanceName, final String restorableDroppedDatabaseId, final ListOperationCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRestorableDroppedDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId),
            new Func1<String, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                    return listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object
     */
    public Observable<Page<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseAsync(final String resourceGroupName, final String managedInstanceName, final String restorableDroppedDatabaseId) {
        return listByRestorableDroppedDatabaseWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId)
            .map(new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Page<ManagedBackupShortTermRetentionPolicyInner>>() {
                @Override
                public Page<ManagedBackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByRestorableDroppedDatabaseWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName, final String restorableDroppedDatabaseId) {
        return listByRestorableDroppedDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId)
            .concatMap(new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRestorableDroppedDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
    ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> * @param managedInstanceName The name of the managed instance.
    ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByRestorableDroppedDatabaseSinglePageAsync(final String resourceGroupName, final String managedInstanceName, final String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByRestorableDroppedDatabase(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> result = listByRestorableDroppedDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object if successful.
     */
    public PagedList<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response = listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedBackupShortTermRetentionPolicyInner>(response.body()) {
            @Override
            public Page<ManagedBackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<ManagedBackupShortTermRetentionPolicyInner>> serviceFuture, final ListOperationCallback<ManagedBackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                    return listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object
     */
    public Observable<Page<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseNextAsync(final String nextPageLink) {
        return listByRestorableDroppedDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Page<ManagedBackupShortTermRetentionPolicyInner>>() {
                @Override
                public Page<ManagedBackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByRestorableDroppedDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listByRestorableDroppedDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRestorableDroppedDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a dropped database's short term retention policy list.
     *
    ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedBackupShortTermRetentionPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> listByRestorableDroppedDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByRestorableDroppedDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> result = listByRestorableDroppedDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedBackupShortTermRetentionPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedBackupShortTermRetentionPolicyInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
