/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SecurityAlertPolicyEmailAccountAdmins;
import com.microsoft.azure.management.sql.SecurityAlertPolicyState;
import com.microsoft.azure.management.sql.SecurityAlertPolicyUseServerDefault;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseThreatDetectionPolicy;
import com.microsoft.azure.management.sql.implementation.DatabaseSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlDatabaseThreatDetectionPolicyImpl
extends ExternalChildResourceImpl<SqlDatabaseThreatDetectionPolicy, DatabaseSecurityAlertPolicyInner, SqlDatabaseImpl, SqlDatabase>
implements SqlDatabaseThreatDetectionPolicy,
SqlDatabaseThreatDetectionPolicy.SqlDatabaseThreatDetectionPolicyDefinition,
SqlDatabaseThreatDetectionPolicy.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    protected SqlDatabaseThreatDetectionPolicyImpl(String name, SqlDatabaseImpl parent, DatabaseSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withLocation(parent.regionName());
    }

    public String name() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).name();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).id();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).location());
    }

    @Override
    public String kind() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).kind();
    }

    @Override
    public SecurityAlertPolicyState currentState() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).state();
    }

    @Override
    public String disabledAlerts() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).disabledAlerts();
    }

    @Override
    public String emailAddresses() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).emailAddresses();
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).emailAccountAdmins() == SecurityAlertPolicyEmailAccountAdmins.ENABLED;
    }

    @Override
    public String storageEndpoint() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).retentionDays();
    }

    @Override
    public boolean isDefaultSecurityAlertPolicy() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).useServerDefault() == SecurityAlertPolicyUseServerDefault.ENABLED;
    }

    protected Observable<DatabaseSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseThreatDetectionPolicies().getAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name());
    }

    public Observable<SqlDatabaseThreatDetectionPolicy> createResourceAsync() {
        final SqlDatabaseThreatDetectionPolicyImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseThreatDetectionPolicies().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), (DatabaseSecurityAlertPolicyInner)((Object)this.inner())).map((Func1)new Func1<DatabaseSecurityAlertPolicyInner, SqlDatabaseThreatDetectionPolicy>(){

            public SqlDatabaseThreatDetectionPolicy call(DatabaseSecurityAlertPolicyInner databaseSecurityAlertPolicyInner) {
                self.setInner((Object)databaseSecurityAlertPolicyInner);
                return self;
            }
        });
    }

    public Observable<SqlDatabaseThreatDetectionPolicy> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public SqlDatabaseThreatDetectionPolicy.Update update() {
        super.prepareUpdate();
        return this;
    }

    public Observable<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyEnabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withState(SecurityAlertPolicyState.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyDisabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withState(SecurityAlertPolicyState.DISABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyNew() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.DISABLED);
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withState(SecurityAlertPolicyState.NEW);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withDefaultSecurityAlertPolicy() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withUseServerDefault(SecurityAlertPolicyUseServerDefault.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageEndpoint(String storageEndpoint) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(String alertsFilter) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withDisabledAlerts(alertsFilter);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(String addresses) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withEmailAddresses(addresses);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withRetentionDays(int retentionDays) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withRetentionDays(retentionDays);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withoutEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.inner())).withEmailAccountAdmins(SecurityAlertPolicyEmailAccountAdmins.DISABLED);
        return this;
    }
}

