/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlFirewallRuleOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.FirewallRuleInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlFirewallRuleImpl
extends ExternalChildResourceImpl<SqlFirewallRule, FirewallRuleInner, SqlServerImpl, SqlServer>
implements SqlFirewallRule,
SqlFirewallRule.SqlFirewallRuleDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlFirewallRule.Update,
SqlFirewallRuleOperations.SqlFirewallRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlFirewallRuleImpl(String name, SqlServerImpl parent, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlFirewallRuleImpl(String resourceGroupName, String sqlServerName, String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlFirewallRuleImpl(String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    protected Observable<FirewallRuleInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlFirewallRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    public String id() {
        return ((FirewallRuleInner)((Object)this.inner())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String startIPAddress() {
        return ((FirewallRuleInner)((Object)this.inner())).startIpAddress();
    }

    @Override
    public String endIPAddress() {
        return ((FirewallRuleInner)((Object)this.inner())).endIpAddress();
    }

    @Override
    public String kind() {
        return ((FirewallRuleInner)((Object)this.inner())).kind();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((FirewallRuleInner)((Object)this.inner())).location());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().toBlocking().last();
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    public Observable<SqlFirewallRule> createResourceAsync() {
        final SqlFirewallRuleImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)((Object)this.inner())).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
    }

    public Observable<SqlFirewallRule> updateResourceAsync() {
        final SqlFirewallRuleImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)((Object)this.inner())).map((Func1)new Func1<FirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(FirewallRuleInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).firewallRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public SqlFirewallRuleImpl withStartIPAddress(String startIPAddress) {
        ((FirewallRuleInner)((Object)this.inner())).withStartIpAddress(startIPAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withEndIPAddress(String endIPAddress) {
        ((FirewallRuleInner)((Object)this.inner())).withEndIpAddress(endIPAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIPAddressRange(String startIPAddress, String endIPAddress) {
        ((FirewallRuleInner)((Object)this.inner())).withStartIpAddress(startIPAddress);
        ((FirewallRuleInner)((Object)this.inner())).withEndIpAddress(endIPAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIPAddress(String ipAddress) {
        ((FirewallRuleInner)((Object)this.inner())).withStartIpAddress(ipAddress);
        ((FirewallRuleInner)((Object)this.inner())).withEndIpAddress(ipAddress);
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }
}

