/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SyncFullSchemaPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncMemberInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SyncMembersInner {
    private SyncMembersService service;
    private SqlManagementClientImpl client;

    public SyncMembersInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (SyncMembersService)retrofit.create(SyncMembersService.class);
        this.client = client;
    }

    public SyncMemberInner get(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return (SyncMemberInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single()).body());
    }

    public ServiceFuture<SyncMemberInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    public Observable<SyncMemberInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>(){

            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return (SyncMemberInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncMemberInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>(){

            public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncMembersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncMemberInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncMemberInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncMemberInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    public Observable<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map((Func1)new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>(){

            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return (SyncMemberInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncMemberInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncMemberInner>(){}.getType());
    }

    public SyncMemberInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    public Observable<SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map((Func1)new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>(){

            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return (SyncMemberInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncMemberInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>(){

            public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncMembersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncMemberInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncMemberInner>(){}.getType()).register(201, new TypeToken<SyncMemberInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncMembersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncMemberInner update(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    public Observable<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map((Func1)new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>(){

            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return (SyncMemberInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncMemberInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncMemberInner>(){}.getType());
    }

    public SyncMemberInner beginUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    public Observable<SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map((Func1)new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>(){

            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return (SyncMemberInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SyncMemberInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        return this.service.beginUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>(){

            public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncMembersInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncMemberInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncMemberInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncMemberInner> listBySyncGroup(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ServiceResponse response = (ServiceResponse)this.listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single();
        return new PagedList<SyncMemberInner>((Page)response.body()){

            public Page<SyncMemberInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncMembersInner.this.listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncMemberInner>> listBySyncGroupAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ListOperationCallback<SyncMemberInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(String nextPageLink) {
                return SyncMembersInner.this.listBySyncGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncMemberInner>> listBySyncGroupAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.listBySyncGroupWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Page<SyncMemberInner>>, Page<SyncMemberInner>>(){

            public Page<SyncMemberInner> call(ServiceResponse<Page<SyncMemberInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncMemberInner>>, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(ServiceResponse<Page<SyncMemberInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncMembersInner.this.listBySyncGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listBySyncGroup(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncMembersInner.this.listBySyncGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncMemberInner>> listBySyncGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncMemberInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncFullSchemaPropertiesInner> listMemberSchemas(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        ServiceResponse response = (ServiceResponse)this.listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>((Page)response.body()){

            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncMembersInner.this.listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listMemberSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                return SyncMembersInner.this.listMemberSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncFullSchemaPropertiesInner>> listMemberSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.listMemberSchemasWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>(){

            public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncMembersInner.this.listMemberSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listMemberSchemas(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncMembersInner.this.listMemberSchemasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listMemberSchemasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void refreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        ((ServiceResponse)this.refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    public Observable<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> refreshMemberSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.refreshMemberSchema(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRefreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        ((ServiceResponse)this.beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    public Observable<Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRefreshMemberSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginRefreshMemberSchema(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncMembersInner.this.beginRefreshMemberSchemaDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRefreshMemberSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncMemberInner> listBySyncGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncMemberInner>((Page)response.body()){

            public Page<SyncMemberInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncMembersInner.this.listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncMemberInner>> listBySyncGroupNextAsync(String nextPageLink, ServiceFuture<List<SyncMemberInner>> serviceFuture, ListOperationCallback<SyncMemberInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySyncGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(String nextPageLink) {
                return SyncMembersInner.this.listBySyncGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncMemberInner>> listBySyncGroupNextAsync(String nextPageLink) {
        return this.listBySyncGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncMemberInner>>, Page<SyncMemberInner>>(){

            public Page<SyncMemberInner> call(ServiceResponse<Page<SyncMemberInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBySyncGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncMemberInner>>, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(ServiceResponse<Page<SyncMemberInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncMembersInner.this.listBySyncGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBySyncGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncMemberInner>>>>(){

            public Observable<ServiceResponse<Page<SyncMemberInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncMembersInner.this.listBySyncGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncMemberInner>> listBySyncGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncMemberInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncFullSchemaPropertiesInner> listMemberSchemasNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>((Page)response.body()){

            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncMembersInner.this.listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listMemberSchemasNextAsync(String nextPageLink, ServiceFuture<List<SyncFullSchemaPropertiesInner>> serviceFuture, ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listMemberSchemasNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                return SyncMembersInner.this.listMemberSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncFullSchemaPropertiesInner>> listMemberSchemasNextAsync(String nextPageLink) {
        return this.listMemberSchemasNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>(){

            public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasNextWithServiceResponseAsync(String nextPageLink) {
        return this.listMemberSchemasNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncMembersInner.this.listMemberSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listMemberSchemasNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncMembersInner.this.listMemberSchemasNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listMemberSchemasNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SyncMembersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Body SyncMemberInner var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Body SyncMemberInner var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Body SyncMemberInner var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Body SyncMemberInner var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listBySyncGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers")
        public Observable<Response<ResponseBody>> listBySyncGroup(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listMemberSchemas"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/schemas")
        public Observable<Response<ResponseBody>> listMemberSchemas(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers refreshMemberSchema"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema")
        public Observable<Response<ResponseBody>> refreshMemberSchema(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginRefreshMemberSchema"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema")
        public Observable<Response<ResponseBody>> beginRefreshMemberSchema(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="syncMemberName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listBySyncGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listBySyncGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listMemberSchemasNext"})
        @GET
        public Observable<Response<ResponseBody>> listMemberSchemasNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

