/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerSecurityAlertPolicy;
import com.microsoft.azure.management.sql.SqlServerSecurityAlertPolicyOperations;
import com.microsoft.azure.management.sql.implementation.ServerSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlServerSecurityAlertPolicyImpl;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerSecurityAlertPolicyOperationsImpl
implements SqlServerSecurityAlertPolicyOperations,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl define() {
        SqlServerSecurityAlertPolicyImpl result = new SqlServerSecurityAlertPolicyImpl(new ServerSecurityAlertPolicyInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public SqlServerSecurityAlertPolicy get() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer);
    }

    @Override
    public Observable<SqlServerSecurityAlertPolicy> getAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer);
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(String resourceGroupName, String sqlServerName) {
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverSecurityAlertPolicies().get(resourceGroupName, sqlServerName);
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, serverSecurityAlertPolicyInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlServerSecurityAlertPolicy> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        final SqlServerSecurityAlertPolicyOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverSecurityAlertPolicies().getAsync(resourceGroupName, sqlServerName).map((Func1)new Func1<ServerSecurityAlertPolicyInner, SqlServerSecurityAlertPolicy>(){

            public SqlServerSecurityAlertPolicy call(ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner) {
                return new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, serverSecurityAlertPolicyInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).serverSecurityAlertPolicies().get(sqlServer.resourceGroupName(), sqlServer.name());
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, serverSecurityAlertPolicyInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlServerSecurityAlertPolicy> getBySqlServerAsync(final SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).serverSecurityAlertPolicies().getAsync(sqlServer.resourceGroupName(), sqlServer.name()).map((Func1)new Func1<ServerSecurityAlertPolicyInner, SqlServerSecurityAlertPolicy>(){

            public SqlServerSecurityAlertPolicy call(ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner) {
                return new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, serverSecurityAlertPolicyInner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlServerSecurityAlertPolicy getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public Observable<SqlServerSecurityAlertPolicy> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }
}

