/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.JobTarget;
import com.microsoft.azure.management.sql.implementation.JobTargetGroupInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobTargetGroupsInner {
    private JobTargetGroupsService service;
    private SqlManagementClientImpl client;

    public JobTargetGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobTargetGroupsService)retrofit.create(JobTargetGroupsService.class);
        this.client = client;
    }

    public PagedList<JobTargetGroupInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        ServiceResponse response = (ServiceResponse)this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobTargetGroupInner>((Page)response.body()){

            public Page<JobTargetGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetGroupsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobTargetGroupInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, ListOperationCallback<JobTargetGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(String nextPageLink) {
                return JobTargetGroupsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobTargetGroupInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Page<JobTargetGroupInner>>, Page<JobTargetGroupInner>>(){

            public Page<JobTargetGroupInner> call(ServiceResponse<Page<JobTargetGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobTargetGroupInner>>> listByAgentWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).concatMap((Func1)new Func1<ServiceResponse<Page<JobTargetGroupInner>>, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(ServiceResponse<Page<JobTargetGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetGroupsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobTargetGroupInner>>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetGroupsInner.this.listByAgentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobTargetGroupInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobTargetGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobTargetGroupInner get(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        return (JobTargetGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<JobTargetGroupInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, ServiceCallback<JobTargetGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName), serviceCallback);
    }

    public Observable<JobTargetGroupInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName).map((Func1)new Func1<ServiceResponse<JobTargetGroupInner>, JobTargetGroupInner>(){

            public JobTargetGroupInner call(ServiceResponse<JobTargetGroupInner> response) {
                return (JobTargetGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobTargetGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (targetGroupName == null) {
            throw new IllegalArgumentException("Parameter targetGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, targetGroupName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobTargetGroupInner>>>(){

            public Observable<ServiceResponse<JobTargetGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobTargetGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobTargetGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobTargetGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobTargetGroupInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, List<JobTarget> members) {
        return (JobTargetGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName, members).toBlocking().single()).body());
    }

    public ServiceFuture<JobTargetGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, List<JobTarget> members, ServiceCallback<JobTargetGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName, members), serviceCallback);
    }

    public Observable<JobTargetGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, List<JobTarget> members) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName, members).map((Func1)new Func1<ServiceResponse<JobTargetGroupInner>, JobTargetGroupInner>(){

            public JobTargetGroupInner call(ServiceResponse<JobTargetGroupInner> response) {
                return (JobTargetGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobTargetGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, List<JobTarget> members) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (targetGroupName == null) {
            throw new IllegalArgumentException("Parameter targetGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (members == null) {
            throw new IllegalArgumentException("Parameter members is required and cannot be null.");
        }
        Validator.validate(members);
        String apiVersion = "2017-03-01-preview";
        JobTargetGroupInner parameters = new JobTargetGroupInner();
        parameters.withMembers(members);
        return this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, targetGroupName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobTargetGroupInner>>>(){

            public Observable<ServiceResponse<JobTargetGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobTargetGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobTargetGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobTargetGroupInner>(){}.getType()).register(201, new TypeToken<JobTargetGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, targetGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String targetGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (targetGroupName == null) {
            throw new IllegalArgumentException("Parameter targetGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, jobAgentName, targetGroupName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobTargetGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobTargetGroupInner> listByAgentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobTargetGroupInner>((Page)response.body()){

            public Page<JobTargetGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetGroupsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobTargetGroupInner>> listByAgentNextAsync(String nextPageLink, ServiceFuture<List<JobTargetGroupInner>> serviceFuture, ListOperationCallback<JobTargetGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(String nextPageLink) {
                return JobTargetGroupsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobTargetGroupInner>> listByAgentNextAsync(String nextPageLink) {
        return this.listByAgentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobTargetGroupInner>>, Page<JobTargetGroupInner>>(){

            public Page<JobTargetGroupInner> call(ServiceResponse<Page<JobTargetGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobTargetGroupInner>>> listByAgentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAgentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobTargetGroupInner>>, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(ServiceResponse<Page<JobTargetGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetGroupsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobTargetGroupInner>>> listByAgentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobTargetGroupInner>>>>(){

            public Observable<ServiceResponse<Page<JobTargetGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetGroupsInner.this.listByAgentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobTargetGroupInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobTargetGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobTargetGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetGroups listByAgent"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups")
        public Observable<Response<ResponseBody>> listByAgent(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="targetGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="targetGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body JobTargetGroupInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="targetGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetGroups listByAgentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAgentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

