/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRule;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRuleOperations;
import com.microsoft.azure.management.sql.implementation.SqlChildrenOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlVirtualNetworkRuleImpl;
import com.microsoft.azure.management.sql.implementation.SqlVirtualNetworkRulesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.VirtualNetworkRuleInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlVirtualNetworkRuleOperationsImpl
extends SqlChildrenOperationsImpl<SqlVirtualNetworkRule>
implements SqlVirtualNetworkRuleOperations,
SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition {
    private SqlVirtualNetworkRulesAsExternalChildResourcesImpl sqlVirtualNetworkRules;

    SqlVirtualNetworkRuleOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
        this.sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlVirtualNetworkRule");
    }

    SqlVirtualNetworkRuleOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
        this.sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlVirtualNetworkRule");
    }

    @Override
    public SqlVirtualNetworkRule getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        VirtualNetworkRuleInner inner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlVirtualNetworkRule> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().getAsync(resourceGroupName, sqlServerName, name).map((Func1)new Func1<VirtualNetworkRuleInner, SqlVirtualNetworkRule>(){

            public SqlVirtualNetworkRule call(VirtualNetworkRuleInner inner) {
                return new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, SqlVirtualNetworkRuleOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public SqlVirtualNetworkRule getBySqlServer(SqlServer sqlServer, String name) {
        if (sqlServer == null) {
            return null;
        }
        VirtualNetworkRuleInner inner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlVirtualNetworkRule> getBySqlServerAsync(final SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).virtualNetworkRules().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map((Func1)new Func1<VirtualNetworkRuleInner, SqlVirtualNetworkRule>(){

            public SqlVirtualNetworkRule call(VirtualNetworkRuleInner inner) {
                return new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Completable deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().deleteAsync(resourceGroupName, sqlServerName, name).toCompletable();
    }

    @Override
    public List<SqlVirtualNetworkRule> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlVirtualNetworkRuleImpl> virtualNetworkRuleSet = new ArrayList<SqlVirtualNetworkRuleImpl>();
        for (VirtualNetworkRuleInner inner : ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().listByServer(resourceGroupName, sqlServerName)) {
            virtualNetworkRuleSet.add(new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(virtualNetworkRuleSet);
    }

    @Override
    public Observable<SqlVirtualNetworkRule> listBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().listByServerAsync(resourceGroupName, sqlServerName).flatMap((Func1)new Func1<Page<VirtualNetworkRuleInner>, Observable<VirtualNetworkRuleInner>>(){

            public Observable<VirtualNetworkRuleInner> call(Page<VirtualNetworkRuleInner> virtualNetworkRuleInnerPage) {
                return Observable.from((Iterable)virtualNetworkRuleInnerPage.items());
            }
        }).map((Func1)new Func1<VirtualNetworkRuleInner, SqlVirtualNetworkRule>(){

            public SqlVirtualNetworkRule call(VirtualNetworkRuleInner inner) {
                return new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, SqlVirtualNetworkRuleOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public List<SqlVirtualNetworkRule> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlVirtualNetworkRuleImpl> virtualNetworkRuleSet = new ArrayList<SqlVirtualNetworkRuleImpl>();
        if (sqlServer != null) {
            for (VirtualNetworkRuleInner inner : ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
                virtualNetworkRuleSet.add(new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(virtualNetworkRuleSet);
    }

    @Override
    public Observable<SqlVirtualNetworkRule> listBySqlServerAsync(final SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).virtualNetworkRules().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).flatMap((Func1)new Func1<Page<VirtualNetworkRuleInner>, Observable<VirtualNetworkRuleInner>>(){

            public Observable<VirtualNetworkRuleInner> call(Page<VirtualNetworkRuleInner> virtualNetworkRuleInnerPage) {
                return Observable.from((Iterable)virtualNetworkRuleInnerPage.items());
            }
        }).map((Func1)new Func1<VirtualNetworkRuleInner, SqlVirtualNetworkRule>(){

            public SqlVirtualNetworkRule call(VirtualNetworkRuleInner inner) {
                return new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, SqlVirtualNetworkRuleOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public SqlVirtualNetworkRuleImpl define(String name) {
        SqlVirtualNetworkRuleImpl result = this.sqlVirtualNetworkRules.defineIndependentVirtualNetworkRule(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

