/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import java.util.List;
import com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A database vulnerability assessment rule baseline.
 */
@JsonFlatten
public class DatabaseVulnerabilityAssessmentRuleBaselineInner extends ProxyResource {
    /**
     * The rule baseline result.
     */
    @JsonProperty(value = "properties.baselineResults", required = true)
    private List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults;

    /**
     * Get the rule baseline result.
     *
     * @return the baselineResults value
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.baselineResults;
    }

    /**
     * Set the rule baseline result.
     *
     * @param baselineResults the baselineResults value to set
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner withBaselineResults(List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        this.baselineResults = baselineResults;
        return this;
    }

}
