/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for SyncAgentState.
 */
public final class SyncAgentState extends ExpandableStringEnum<SyncAgentState> {
    /** Static value Online for SyncAgentState. */
    public static final SyncAgentState ONLINE = fromString("Online");

    /** Static value Offline for SyncAgentState. */
    public static final SyncAgentState OFFLINE = fromString("Offline");

    /** Static value NeverConnected for SyncAgentState. */
    public static final SyncAgentState NEVER_CONNECTED = fromString("NeverConnected");

    /**
     * Creates or finds a SyncAgentState from its string representation.
     * @param name a name to look for
     * @return the corresponding SyncAgentState
     */
    @JsonCreator
    public static SyncAgentState fromString(String name) {
        return fromString(name, SyncAgentState.class);
    }

    /**
     * @return known SyncAgentState values
     */
    public static Collection<SyncAgentState> values() {
        return values(SyncAgentState.class);
    }
}
